/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.gateway.mktdata;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.dromara.northstar.common.constant.DateTimeConstant;
import org.dromara.northstar.gateway.TradeTimeDefinition;
import org.dromara.northstar.gateway.time.OpenningMinuteClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.redtorch.pb.CoreField;

public class MinuteBarGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MinuteBarGenerator.class);
    private CoreField.BarField.Builder barBuilder;
    private static final long MAX_TIME_GAP = 15000L;
    private LocalDateTime cutoffTime;
    private CoreField.ContractField contract;
    private OpenningMinuteClock clock;
    private CoreField.TickField lastTick;
    Consumer<CoreField.BarField> onBarCallback;

    public MinuteBarGenerator(CoreField.ContractField contract, TradeTimeDefinition tradeTimeDefinition, Consumer<CoreField.BarField> onBarCallback) {
        this.contract = contract;
        this.onBarCallback = onBarCallback;
        this.clock = new OpenningMinuteClock(tradeTimeDefinition);
    }

    public synchronized void update(CoreField.TickField tick) {
        if (tick == null) {
            return;
        }
        boolean sameSymbol = StringUtils.equals((CharSequence)this.contract.getUnifiedSymbol(), (CharSequence)tick.getUnifiedSymbol());
        boolean sameChannel = StringUtils.equals((CharSequence)this.contract.getChannelType(), (CharSequence)tick.getChannelType());
        if (!sameSymbol || !sameChannel) {
            if (!sameSymbol) {
                log.warn("\u5408\u7ea6\u4e0d\u5339\u914d\uff0c\u671f\u671b [{}]\uff0c\u5b9e\u9645 [{}]", (Object)this.contract.getUnifiedSymbol(), (Object)tick.getUnifiedSymbol());
            }
            if (!sameChannel) {
                log.warn("[{}] \u5408\u7ea6\u6e20\u9053\u4e0d\u5339\u914d\uff0c\u671f\u671b [{}]\uff0c\u5b9e\u9645 [{}]", new Object[]{this.contract.getUnifiedSymbol(), this.contract.getChannelType(), tick.getChannelType()});
            }
            return;
        }
        if (System.currentTimeMillis() - tick.getActionTimestamp() > 15000L) {
            log.debug("\u5ffd\u7565\u8fc7\u671f\u6570\u636e: {} {} {}", new Object[]{tick.getUnifiedSymbol(), tick.getActionDay(), tick.getActionTime()});
            return;
        }
        if (tick.getStatus() < 1 && !this.clock.isValidOpenningTick(tick)) {
            return;
        }
        this.lastTick = tick;
        if (Objects.nonNull(this.cutoffTime) && !this.clock.isEndOfSection(this.cutoffTime.toLocalTime()) && tick.getActionTimestamp() >= this.cutoffTime.toInstant(ZoneOffset.ofHours(8)).toEpochMilli()) {
            this.finishOfBar();
        }
        if (Objects.isNull(this.barBuilder)) {
            this.cutoffTime = this.clock.barMinute(tick);
            this.barBuilder = CoreField.BarField.newBuilder().setGatewayId(tick.getGatewayId()).setChannelType(tick.getChannelType()).setUnifiedSymbol(tick.getUnifiedSymbol()).setTradingDay(tick.getTradingDay()).setOpenPrice(tick.getLastPrice()).setHighPrice(tick.getLastPrice()).setLowPrice(tick.getLastPrice()).setPreClosePrice(tick.getPreClosePrice()).setPreOpenInterest(tick.getPreOpenInterest()).setPreSettlePrice(tick.getPreSettlePrice()).setActionDay(tick.getActionDay()).setActionTime(this.cutoffTime.format(DateTimeConstant.T_FORMAT_FORMATTER)).setActionTimestamp(this.cutoffTime.toInstant(ZoneOffset.ofHours(8)).toEpochMilli());
        }
        this.barBuilder.setHighPrice(Math.max(tick.getLastPrice(), this.barBuilder.getHighPrice()));
        this.barBuilder.setLowPrice(Math.min(tick.getLastPrice(), this.barBuilder.getLowPrice()));
        this.barBuilder.setClosePrice(tick.getLastPrice());
        this.barBuilder.setOpenInterest(tick.getOpenInterest());
        this.barBuilder.setOpenInterestDelta(tick.getOpenInterestDelta() + this.barBuilder.getOpenInterestDelta());
        this.barBuilder.setVolume(tick.getVolumeDelta() + this.barBuilder.getVolume());
        this.barBuilder.setTurnover(tick.getTurnoverDelta() + this.barBuilder.getTurnover());
        this.barBuilder.setNumTrades(tick.getNumTradesDelta() + this.barBuilder.getNumTrades());
    }

    public synchronized CoreField.BarField finishOfBar() {
        if (Objects.isNull(this.barBuilder)) {
            return null;
        }
        this.barBuilder.setVolume(Math.max(0L, this.barBuilder.getVolume()));
        CoreField.BarField lastBar = this.barBuilder.build();
        this.onBarCallback.accept(lastBar);
        this.barBuilder = null;
        this.cutoffTime = null;
        return lastBar;
    }

    public synchronized void forceEndOfBar() {
        if (Objects.isNull(this.lastTick) || System.currentTimeMillis() - this.lastTick.getActionTimestamp() < 15000L) {
            return;
        }
        this.finishOfBar();
    }
}

