/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.utils;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;

public class MarketDataLoadingUtils {
    private LocalTime breakingTime = LocalTime.of(20, 0);

    public LocalDate getCurrentTradeDay(long curTimestamp, boolean autoExtend) {
        LocalDateTime ldt = LocalDateTime.ofInstant(Instant.ofEpochMilli(curTimestamp), ZoneId.systemDefault());
        LocalDate nowDate = ldt.toLocalDate();
        LocalTime nowTime = ldt.toLocalTime();
        if (!autoExtend || nowTime.isBefore(this.breakingTime) && nowDate.getDayOfWeek().getValue() < 6) {
            return nowDate;
        }
        if (nowDate.getDayOfWeek().getValue() < 5) {
            return nowDate.plusDays(1L);
        }
        int incrDay = 8 - nowDate.getDayOfWeek().getValue();
        return nowDate.plusDays(incrDay);
    }

    public LocalDate getFridayOfLastWeek(long curTimestamp) {
        LocalDateTime ldt = LocalDateTime.ofInstant(Instant.ofEpochMilli(curTimestamp), ZoneId.systemDefault());
        LocalDate nowDate = ldt.toLocalDate();
        return nowDate.minusDays((long)nowDate.getDayOfWeek().getValue() + 2L);
    }

    public LocalDate getFridayOfThisWeek(LocalDate date) {
        return switch (date.getDayOfWeek()) {
            case DayOfWeek.FRIDAY -> date;
            case DayOfWeek.SATURDAY, DayOfWeek.SUNDAY -> date.minusDays((long)date.getDayOfWeek().getValue() - 5L);
            default -> date.plusDays(5L - (long)date.getDayOfWeek().getValue());
        };
    }
}

