/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.gateway;

import lombok.Generated;
import org.dromara.northstar.common.constant.ConnectionState;
import org.dromara.northstar.common.constant.GatewayUsage;
import org.dromara.northstar.common.event.FastEventEngine;
import org.dromara.northstar.common.model.GatewayDescription;
import org.dromara.northstar.gateway.Gateway;
import org.dromara.northstar.gateway.IMarketCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GatewayAbstract
implements Gateway {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GatewayAbstract.class);
    protected String gatewayId;
    protected String logInfo;
    protected boolean autoErrorFlag = false;
    protected long lastConnectBeginTimestamp = 0L;
    protected String gatewayTradingDay;
    protected GatewayDescription gatewayDescription;
    protected FastEventEngine fastEventEngine;
    protected ConnectionState connState = ConnectionState.DISCONNECTED;
    public final IMarketCenter mktCenter;

    protected GatewayAbstract(GatewayDescription gatewayDescription, IMarketCenter mktCenter) {
        this.mktCenter = mktCenter;
        this.gatewayDescription = gatewayDescription;
        this.gatewayId = gatewayDescription.getGatewayId();
        this.logInfo = (gatewayDescription.getGatewayUsage() == GatewayUsage.MARKET_DATA ? "\u884c\u60c5" : "\u4ea4\u6613") + "\u7f51\u5173ID-[" + this.gatewayId + "] [\u2192] ";
        log.info(this.logInfo + "\u5f00\u59cb\u521d\u59cb\u5316");
    }

    @Override
    public boolean getAuthErrorFlag() {
        return this.autoErrorFlag;
    }

    @Override
    public GatewayDescription gatewayDescription() {
        this.gatewayDescription.setConnectionState(this.connState);
        return this.gatewayDescription;
    }

    @Override
    public String gatewayId() {
        return this.gatewayId;
    }

    protected String getLogInfo() {
        return this.logInfo;
    }

    public FastEventEngine getEventEngine() {
        return this.fastEventEngine;
    }

    public void setAuthErrorFlag(boolean flag) {
        this.autoErrorFlag = flag;
    }

    public void setConnectionState(ConnectionState state) {
        this.connState = state;
    }
}

