/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.gateway.mktdata;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.dromara.northstar.common.TickDataAware;
import org.dromara.northstar.common.constant.ChannelType;
import org.dromara.northstar.common.event.FastEventEngine;
import org.dromara.northstar.common.exception.NoSuchElementException;
import org.dromara.northstar.common.model.Identifier;
import org.dromara.northstar.gateway.Contract;
import org.dromara.northstar.gateway.IMarketCenter;
import org.dromara.northstar.gateway.Instrument;
import org.dromara.northstar.gateway.MarketGateway;
import org.dromara.northstar.gateway.contract.GatewayContract;
import org.dromara.northstar.gateway.contract.IndexContract;
import org.dromara.northstar.gateway.contract.OptionChainContract;
import org.dromara.northstar.gateway.contract.PrimaryContract;
import org.dromara.northstar.gateway.model.ContractDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.redtorch.pb.CoreEnum;
import xyz.redtorch.pb.CoreField;

public class MarketCenter
implements IMarketCenter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MarketCenter.class);
    private static final int INIT_SIZE = 16384;
    private final ConcurrentMap<Identifier, Contract> contractMap = new ConcurrentHashMap<Identifier, Contract>(16384);
    private final ConcurrentMap<Contract, IndexContract> idxContractMap = new ConcurrentHashMap<Contract, IndexContract>(16384);
    private final Table<ChannelType, String, Contract> channelSymbolContractTbl = HashBasedTable.create();
    private final Table<CoreEnum.ExchangeEnum, CoreEnum.ProductClassEnum, List<ContractDefinition>> contractDefTbl = HashBasedTable.create();
    private final Table<ChannelType, ContractDefinition, List<Contract>> channelDefContractGroups = HashBasedTable.create();
    private final Map<ChannelType, MarketGateway> gatewayMap = new EnumMap<ChannelType, MarketGateway>(ChannelType.class);
    private final FastEventEngine feEngine;

    public MarketCenter(FastEventEngine feEngine) {
        this.feEngine = feEngine;
    }

    @Override
    public void addDefinitions(List<ContractDefinition> contractDefs) {
        for (ContractDefinition def : contractDefs) {
            if (!this.contractDefTbl.contains((Object)def.getExchange(), (Object)def.getProductClass())) {
                this.contractDefTbl.put((Object)def.getExchange(), (Object)def.getProductClass(), new ArrayList(512));
            }
            ((List)this.contractDefTbl.get((Object)def.getExchange(), (Object)def.getProductClass())).add(def);
        }
    }

    @Override
    public synchronized void addInstrument(Instrument ins) {
        List defList = (List)this.contractDefTbl.get((Object)ins.exchange(), (Object)ins.productClass());
        if (Objects.isNull(defList)) {
            log.debug("\u672a\u627e\u5230 [{}] \u7684\u5408\u7ea6\u5b9a\u4e49\uff0c\u5ffd\u7565\u8be5\u5408\u7ea6\u7684\u6ce8\u518c", (Object)ins.identifier().value());
            return;
        }
        for (ContractDefinition def : defList) {
            if (!def.getSymbolPattern().matcher(ins.identifier().value()).matches()) continue;
            log.debug("[{}] \u5339\u914d\u5408\u7ea6\u5b9a\u4e49 [{} {} {}]", new Object[]{ins.identifier().value(), def.getExchange(), def.getProductClass(), def.getSymbolPattern().pattern()});
            ins.setContractDefinition(def);
            GatewayContract contract = new GatewayContract(this, this.feEngine, ins);
            this.contractMap.put(ins.identifier(), contract);
            if (!this.channelDefContractGroups.contains((Object)ins.channelType(), (Object)def)) {
                this.channelDefContractGroups.put((Object)ins.channelType(), (Object)def, new ArrayList());
            }
            ((List)this.channelDefContractGroups.get((Object)ins.channelType(), (Object)def)).add(contract);
            this.channelSymbolContractTbl.put((Object)contract.channelType(), (Object)contract.contractField().getSymbol(), (Object)contract);
            this.channelSymbolContractTbl.put((Object)contract.channelType(), (Object)contract.contractField().getUnifiedSymbol(), (Object)contract);
        }
        if (!this.contractMap.containsKey(ins.identifier())) {
            log.debug("\u672a\u627e\u5230 [{}] \u7684\u5408\u7ea6\u5b9a\u4e49\uff0c\u5ffd\u7565\u8be5\u5408\u7ea6\u7684\u6ce8\u518c", (Object)ins.identifier().value());
        }
    }

    @Override
    public synchronized void loadContractGroup(ChannelType channelType) {
        List<Contract> gatewayContracts = this.getContracts(channelType);
        HashMap<String, Contract> symbolContractMap = new HashMap<String, Contract>();
        for (Contract c2 : gatewayContracts) {
            symbolContractMap.put(c2.contractField().getSymbol(), c2);
        }
        try {
            this.aggregateOptionContracts(gatewayContracts.stream().filter(c -> c.productClass() == CoreEnum.ProductClassEnum.OPTION).toList(), symbolContractMap);
        }
        catch (Exception e) {
            log.error("\u805a\u5408\u671f\u6743\u94fe\u5408\u7ea6\u65f6\u51fa\u9519", (Throwable)e);
        }
        try {
            this.aggregateFutureIndexContracts(this.channelDefContractGroups.row((Object)channelType));
        }
        catch (Exception e) {
            log.error("\u805a\u5408\u671f\u8d27\u6307\u6570\u5408\u7ea6\u65f6\u51fa\u9519", (Throwable)e);
        }
    }

    private void aggregateOptionContracts(List<Contract> optContracts, Map<String, Contract> symbolContractMap) {
        HashMap<String, List> symbolOptionsMap = new HashMap<String, List>();
        for (Contract contract : optContracts) {
            if (contract instanceof OptionChainContract) continue;
            String underlyingSymbol = contract.contractField().getUnderlyingSymbol();
            symbolOptionsMap.computeIfAbsent(underlyingSymbol, key -> new ArrayList());
            ((List)symbolOptionsMap.get(underlyingSymbol)).add(contract);
        }
        for (Map.Entry entry : symbolOptionsMap.entrySet()) {
            if (!symbolContractMap.containsKey(entry.getKey())) {
                log.warn("\u627e\u4e0d\u5230{}\u5bf9\u5e94\u7684\u5408\u7ea6\u4fe1\u606f", entry.getKey());
                continue;
            }
            OptionChainContract c = new OptionChainContract(symbolContractMap.get(entry.getKey()), (List)entry.getValue());
            this.contractMap.put(c.identifier(), c);
        }
    }

    private void aggregateFutureIndexContracts(Map<ContractDefinition, List<Contract>> contractDefMap) {
        for (Map.Entry<ContractDefinition, List<Contract>> e : contractDefMap.entrySet()) {
            if (e.getKey().getProductClass() != CoreEnum.ProductClassEnum.FUTURES) continue;
            IndexContract c = new IndexContract(this.feEngine, e.getValue());
            this.contractMap.put(c.identifier(), c);
            for (Contract memberContract : c.memberContracts()) {
                this.idxContractMap.put(memberContract, c);
            }
            this.channelSymbolContractTbl.put((Object)c.channelType(), (Object)c.contractField().getSymbol(), (Object)c);
            this.channelSymbolContractTbl.put((Object)c.channelType(), (Object)c.contractField().getUnifiedSymbol(), (Object)c);
            if (c.channelType() != ChannelType.CTP) continue;
            PrimaryContract pc = new PrimaryContract(c);
            this.contractMap.put(pc.identifier(), pc);
            this.channelSymbolContractTbl.put((Object)pc.channelType(), (Object)pc.contractField().getSymbol(), (Object)pc);
            this.channelSymbolContractTbl.put((Object)pc.channelType(), (Object)pc.contractField().getUnifiedSymbol(), (Object)pc);
        }
    }

    @Override
    public Contract getContract(Identifier identifier) {
        if (!this.contractMap.containsKey(identifier)) {
            throw new NoSuchElementException(String.format("\u627e\u4e0d\u5230\u5408\u7ea6\uff1a%s", identifier.value()));
        }
        return (Contract)this.contractMap.get(identifier);
    }

    @Override
    public Contract getContract(ChannelType channelType, String code) {
        if (!this.channelSymbolContractTbl.contains((Object)channelType, (Object)code)) {
            throw new NoSuchElementException(String.format("\u627e\u4e0d\u5230\u5408\u7ea6\uff1a%s -> %s", new Object[]{channelType, code}));
        }
        return (Contract)this.channelSymbolContractTbl.get((Object)channelType, (Object)code);
    }

    @Override
    public List<Contract> getContracts(String gatewayId) {
        if (StringUtils.isBlank((CharSequence)gatewayId)) {
            return this.contractMap.values().stream().toList();
        }
        return this.contractMap.values().stream().filter(c -> StringUtils.equals((CharSequence)gatewayId, (CharSequence)c.gatewayId())).toList();
    }

    @Override
    public List<Contract> getContracts(ChannelType channelType) {
        return this.contractMap.values().stream().filter(c -> c.channelType() == channelType).toList();
    }

    @Override
    public void onTick(CoreField.TickField tick) {
        IndexContract idxContract;
        Contract contract = this.getContract(ChannelType.valueOf(tick.getChannelType()), tick.getUnifiedSymbol());
        if (contract instanceof TickDataAware) {
            TickDataAware tdAware = (TickDataAware)((Object)contract);
            tdAware.onTick(tick);
        }
        if (Objects.nonNull(idxContract = (IndexContract)this.idxContractMap.get(contract))) {
            idxContract.onTick(tick);
        } else if (contract.productClass() == CoreEnum.ProductClassEnum.FUTURES) {
            log.trace("\u6ca1\u6709\u627e\u5230 [{}] \u5bf9\u5e94\u7684\u6307\u6570\u5408\u7ea6", (Object)contract.identifier());
        }
    }

    @Override
    public void endOfMarketTime() {
        this.contractMap.values().stream().filter(TickDataAware.class::isInstance).map(TickDataAware.class::cast).forEach(TickDataAware::endOfMarket);
    }

    @Override
    public void addGateway(MarketGateway gateway) {
        log.info("\u6ce8\u518c\u7f51\u5173\u6e20\u9053\uff1a{}", (Object)gateway.gatewayId());
        this.gatewayMap.put(gateway.channelType(), gateway);
    }

    @Override
    public MarketGateway getGateway(ChannelType channelType) {
        return this.gatewayMap.get((Object)channelType);
    }
}

