/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.model;

import java.time.LocalDateTime;
import java.util.Arrays;
import lombok.Generated;
import org.dromara.northstar.common.utils.MessagePrinter;
import xyz.redtorch.pb.CoreField;

public class Message {
    private LocalDateTime dateTime;
    private String title;
    private String content;
    private String[] receivers;

    public Message(String title, String content, String[] receivers) {
        this.title = title;
        this.content = content;
        this.receivers = receivers;
        this.dateTime = LocalDateTime.now();
    }

    public Message(CoreField.NoticeField notice, String[] receivers) {
        this(String.format("Northstar\u6d88\u606f\u901a\u77e5 - [%s]", notice.getStatus().toString()), notice.getContent(), receivers);
    }

    public Message(CoreField.OrderField order, String[] receivers) {
        this(String.format("Northstar\u4e0b\u5355\u901a\u77e5 - [%s]", order.getGatewayId()), MessagePrinter.print(order), receivers);
    }

    public Message(CoreField.TradeField trade, String[] receivers) {
        this(String.format("Northstar\u6210\u4ea4\u901a\u77e5 - [%s]", trade.getGatewayId()), MessagePrinter.print(trade), receivers);
    }

    @Generated
    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String[] getReceivers() {
        return this.receivers;
    }

    @Generated
    public void setDateTime(LocalDateTime dateTime) {
        this.dateTime = dateTime;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setReceivers(String[] receivers) {
        this.receivers = receivers;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocalDateTime this$dateTime = this.getDateTime();
        LocalDateTime other$dateTime = other.getDateTime();
        if (this$dateTime == null ? other$dateTime != null : !((Object)this$dateTime).equals(other$dateTime)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        return Arrays.deepEquals(this.getReceivers(), other.getReceivers());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDateTime $dateTime = this.getDateTime();
        result = result * 59 + ($dateTime == null ? 43 : ((Object)$dateTime).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getReceivers());
        return result;
    }

    @Generated
    public String toString() {
        return "Message(dateTime=" + this.getDateTime() + ", title=" + this.getTitle() + ", content=" + this.getContent() + ", receivers=" + Arrays.deepToString(this.getReceivers()) + ")";
    }
}

