/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.gateway.contract;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.dromara.northstar.common.TickDataAware;
import org.dromara.northstar.common.constant.ChannelType;
import org.dromara.northstar.common.event.FastEventEngine;
import org.dromara.northstar.common.event.NorthstarEventType;
import org.dromara.northstar.common.model.Identifier;
import org.dromara.northstar.gateway.Contract;
import org.dromara.northstar.gateway.TradeTimeDefinition;
import org.dromara.northstar.gateway.mktdata.IndexTicker;
import org.dromara.northstar.gateway.mktdata.MinuteBarGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.redtorch.pb.CoreEnum;
import xyz.redtorch.pb.CoreField;

public class IndexContract
implements Contract,
TickDataAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndexContract.class);
    private final List<Contract> monthContracts;
    private final MinuteBarGenerator barGen;
    private final IndexTicker ticker;
    private final CoreField.ContractField contract;
    private final Identifier identifier;

    public IndexContract(FastEventEngine feEngine, List<Contract> monthContracts) {
        this.monthContracts = monthContracts;
        this.contract = this.makeIndexContractField(monthContracts.get(0).contractField());
        this.identifier = Identifier.of(this.contract.getContractId());
        this.barGen = new MinuteBarGenerator(this.contract, monthContracts.get(0).tradeTimeDefinition(), bar -> feEngine.emitEvent(NorthstarEventType.BAR, bar));
        this.ticker = new IndexTicker(this, t -> {
            feEngine.emitEvent(NorthstarEventType.TICK, t);
            this.barGen.update((CoreField.TickField)t);
        });
    }

    private CoreField.ContractField makeIndexContractField(CoreField.ContractField proto) {
        String name = proto.getName().replaceAll("\\d+$", "\u6307\u6570");
        String fullName = proto.getFullName().replaceAll("\\d+$", "\u6307\u6570");
        String originSymbol = proto.getSymbol();
        String symbol = originSymbol.replaceAll("\\d+$", "0000");
        String contractId = proto.getContractId().replace(originSymbol, symbol);
        String thirdPartyId = proto.getThirdPartyId().replace(originSymbol, symbol);
        String unifiedSymbol = proto.getUnifiedSymbol().replace(originSymbol, symbol);
        return CoreField.ContractField.newBuilder(proto).setSymbol(symbol).setThirdPartyId(thirdPartyId).setContractId(contractId).setLastTradeDateOrContractMonth("").setUnifiedSymbol(unifiedSymbol).setFullName(fullName).setLongMarginRatio(0.1).setShortMarginRatio(0.1).setName(name).build();
    }

    @Override
    public boolean subscribe() {
        log.debug("\u8ba2\u9605\uff1a{}", (Object)this.identifier.value());
        for (Contract c : this.monthContracts) {
            if (c.subscribe()) continue;
            log.warn("[{}] \u5408\u7ea6\u8ba2\u9605\u5931\u8d25", (Object)c.contractField().getUnifiedSymbol());
        }
        return true;
    }

    @Override
    public boolean unsubscribe() {
        log.debug("\u9000\u8ba2\uff1a{}", (Object)this.identifier.value());
        for (Contract c : this.monthContracts) {
            if (c.unsubscribe()) continue;
            log.warn("[{}] \u5408\u7ea6\u53d6\u6d88\u8ba2\u9605\u5931\u8d25", (Object)c.contractField().getUnifiedSymbol());
        }
        return true;
    }

    @Override
    public void onTick(CoreField.TickField tick) {
        this.ticker.update(tick);
    }

    @Override
    public List<Contract> memberContracts() {
        return this.monthContracts;
    }

    @Override
    public CoreField.ContractField contractField() {
        return this.contract;
    }

    @Override
    public String name() {
        return this.contract.getName();
    }

    @Override
    public Identifier identifier() {
        return this.identifier;
    }

    @Override
    public CoreEnum.ProductClassEnum productClass() {
        return this.contract.getProductClass();
    }

    @Override
    public CoreEnum.ExchangeEnum exchange() {
        return this.contract.getExchange();
    }

    @Override
    public String gatewayId() {
        return this.contract.getGatewayId();
    }

    @Override
    public TradeTimeDefinition tradeTimeDefinition() {
        return this.monthContracts.get(0).tradeTimeDefinition();
    }

    @Override
    public ChannelType channelType() {
        return this.monthContracts.get(0).channelType();
    }

    @Override
    public void endOfMarket() {
        this.barGen.forceEndOfBar();
    }

    public int hashCode() {
        return Objects.hash(this.contract.getContractId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexContract other = (IndexContract)obj;
        return StringUtils.equals((CharSequence)this.contract.getContractId(), (CharSequence)other.contract.getContractId());
    }
}

