/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.gateway.mktdata;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.northstar.gateway.contract.IndexContract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.redtorch.pb.CoreField;

public class IndexTicker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndexTicker.class);
    private IndexContract idxContract;
    private Consumer<CoreField.TickField> onTickCallback;
    private static final long PARA_THRESHOLD = 100L;
    private final Set<String> memberContracts;
    private ConcurrentHashMap<String, CoreField.TickField> tickMap = new ConcurrentHashMap(20);
    private ConcurrentHashMap<String, Double> weightedMap = new ConcurrentHashMap(20);
    private long lastTickTimestamp = -1L;
    protected final CoreField.TickField.Builder tickBuilder = CoreField.TickField.newBuilder();

    public IndexTicker(IndexContract idxContract, Consumer<CoreField.TickField> onTickCallback) {
        this.idxContract = idxContract;
        this.memberContracts = idxContract.memberContracts().stream().map(c -> c.contractField().getUnifiedSymbol()).collect(Collectors.toSet());
        this.onTickCallback = onTickCallback;
        CoreField.ContractField cf = idxContract.contractField();
        this.tickBuilder.setUnifiedSymbol(cf.getUnifiedSymbol());
        this.tickBuilder.setGatewayId(cf.getGatewayId());
        this.tickBuilder.setChannelType(cf.getChannelType());
        this.tickBuilder.addAllAskPrice(Arrays.asList(0.0, 0.0, 0.0, 0.0, 0.0));
        this.tickBuilder.addAllBidPrice(Arrays.asList(0.0, 0.0, 0.0, 0.0, 0.0));
        this.tickBuilder.addAllAskVolume(Arrays.asList(0, 0, 0, 0, 0));
        this.tickBuilder.addAllBidVolume(Arrays.asList(0, 0, 0, 0, 0));
    }

    public Set<String> dependencySymbols() {
        return this.memberContracts;
    }

    public synchronized void update(CoreField.TickField tick) {
        if (!this.dependencySymbols().contains(tick.getUnifiedSymbol())) {
            log.warn("[{}]\u6307\u6570TICK\u751f\u6210\u5668\uff0c\u65e0\u6cd5\u5904\u7406 [{}] \u7684\u884c\u60c5\u6570\u636e", (Object)this.idxContract.contractField().getUnifiedSymbol(), (Object)tick.getUnifiedSymbol());
            return;
        }
        if (this.lastTickTimestamp < tick.getActionTimestamp()) {
            if (this.lastTickTimestamp > 0L) {
                this.calculate();
                CoreField.TickField t = this.tickBuilder.build();
                this.onTickCallback.accept(t);
            }
            this.lastTickTimestamp = tick.getActionTimestamp();
            this.tickBuilder.setTradingDay(tick.getTradingDay());
            this.tickBuilder.setActionDay(tick.getActionDay());
            this.tickBuilder.setActionTime(tick.getActionTime());
            this.tickBuilder.setActionTimestamp(tick.getActionTimestamp());
            this.tickBuilder.setPreClosePrice(tick.getPreClosePrice());
            this.tickBuilder.setPreOpenInterest(tick.getPreOpenInterest());
            this.tickBuilder.setPreSettlePrice(tick.getPreSettlePrice());
            this.tickBuilder.setStatus(tick.getStatus());
        }
        this.tickMap.compute(tick.getUnifiedSymbol(), (k, v) -> tick);
    }

    private void calculate() {
        double totalOpenInterest = this.tickMap.reduceValuesToDouble(100L, CoreField.TickField::getOpenInterest, 0.0, (a, b) -> a + b);
        double totalOpenInterestDelta = this.tickMap.reduceValuesToDouble(100L, CoreField.TickField::getOpenInterestDelta, 0.0, (a, b) -> a + b);
        this.tickMap.forEachEntry(100L, e -> this.weightedMap.compute((String)e.getKey(), (k, v) -> ((CoreField.TickField)e.getValue()).getOpenInterest() * 1.0 / totalOpenInterest));
        long totalVolume = this.tickMap.reduceValuesToLong(100L, CoreField.TickField::getVolume, 0L, (a, b) -> a + b);
        long totalVolumeDelta = this.tickMap.reduceValuesToLong(100L, CoreField.TickField::getVolumeDelta, 0L, (a, b) -> a + b);
        double totalTurnover = this.tickMap.reduceValuesToDouble(100L, CoreField.TickField::getTurnover, 0.0, (a, b) -> a + b);
        double totalTurnoverDelta = this.tickMap.reduceValuesToDouble(100L, CoreField.TickField::getTurnoverDelta, 0.0, (a, b) -> a + b);
        double rawWeightedLastPrice = this.computeWeightedValue(e -> this.tickMap.get(e.getKey()).getLastPrice() * (Double)e.getValue());
        double weightedLastPrice = this.roundWithPriceTick(rawWeightedLastPrice);
        this.tickBuilder.setLastPrice(weightedLastPrice);
        double rawWeightedHighPrice = this.computeWeightedValue(e -> this.tickMap.get(e.getKey()).getHighPrice() * (Double)e.getValue());
        double weightedHighPrice = this.roundWithPriceTick(rawWeightedHighPrice);
        this.tickBuilder.setHighPrice(weightedHighPrice);
        double rawWeightedLowPrice = this.computeWeightedValue(e -> this.tickMap.get(e.getKey()).getLowPrice() * (Double)e.getValue());
        double weightedLowPrice = this.roundWithPriceTick(rawWeightedLowPrice);
        this.tickBuilder.setLowPrice(weightedLowPrice);
        double rawWeightedOpenPrice = this.computeWeightedValue(e -> this.tickMap.get(e.getKey()).getOpenPrice() * (Double)e.getValue());
        double weightedOpenPrice = this.roundWithPriceTick(rawWeightedOpenPrice);
        this.tickBuilder.setOpenPrice(weightedOpenPrice);
        this.tickBuilder.setVolume(totalVolume);
        this.tickBuilder.setVolumeDelta(totalVolumeDelta);
        this.tickBuilder.setOpenInterestDelta(totalOpenInterestDelta);
        this.tickBuilder.setOpenInterest(totalOpenInterest);
        this.tickBuilder.setTurnover(totalTurnover);
        this.tickBuilder.setTurnoverDelta(totalTurnoverDelta);
    }

    private double computeWeightedValue(ToDoubleFunction<Map.Entry<String, Double>> transformer) {
        return this.weightedMap.reduceEntriesToDouble(100L, transformer, 0.0, (a, b) -> a + b);
    }

    private double roundWithPriceTick(double weightedPrice) {
        int enlargePrice = (int)(weightedPrice * 1000.0);
        int enlargePriceTick = (int)(this.idxContract.contractField().getPriceTick() * 1000.0);
        int numOfTicks = enlargePrice / enlargePriceTick;
        int tickCarry = enlargePrice % enlargePriceTick < enlargePriceTick / 2 ? 0 : 1;
        return (double)(enlargePriceTick * (numOfTicks + tickCarry)) * 1.0 / 1000.0;
    }
}

