/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.constant;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.dromara.northstar.common.constant.SignalOperation;
import xyz.redtorch.pb.CoreEnum;
import xyz.redtorch.pb.CoreField;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ClosingPolicy {
    FIRST_IN_FIRST_OUT("\u5148\u5f00\u5148\u5e73"){

        @Override
        public CoreEnum.OffsetFlagEnum resolveOffsetFlag(SignalOperation operation, CoreField.ContractField contract, List<CoreField.TradeField> nonclosedTrades, String tradingDay) {
            if (operation.isOpen()) {
                return CoreEnum.OffsetFlagEnum.OF_Open;
            }
            this.checkNonclosedTrades(nonclosedTrades, contract);
            ArrayList<CoreField.TradeField> wrapList = new ArrayList<CoreField.TradeField>(nonclosedTrades);
            wrapList.sort((a, b) -> a.getTradeTimestamp() < b.getTradeTimestamp() ? -1 : 1);
            if (StringUtils.equals((CharSequence)tradingDay, (CharSequence)((CoreField.TradeField)wrapList.get(0)).getTradingDay())) {
                return CoreEnum.OffsetFlagEnum.OF_CloseToday;
            }
            return CoreEnum.OffsetFlagEnum.OF_Close;
        }
    }
    ,
    FIRST_IN_LAST_OUT("\u5e73\u4eca\u4f18\u5148"){

        @Override
        public CoreEnum.OffsetFlagEnum resolveOffsetFlag(SignalOperation operation, CoreField.ContractField contract, List<CoreField.TradeField> nonclosedTrades, String tradingDay) {
            if (operation.isOpen()) {
                return CoreEnum.OffsetFlagEnum.OF_Open;
            }
            this.checkNonclosedTrades(nonclosedTrades, contract);
            ArrayList<CoreField.TradeField> wrapList = new ArrayList<CoreField.TradeField>(nonclosedTrades);
            wrapList.sort((a, b) -> a.getTradeTimestamp() > b.getTradeTimestamp() ? -1 : 1);
            if (StringUtils.equals((CharSequence)tradingDay, (CharSequence)((CoreField.TradeField)wrapList.get(0)).getTradingDay())) {
                return CoreEnum.OffsetFlagEnum.OF_CloseToday;
            }
            return CoreEnum.OffsetFlagEnum.OF_Close;
        }
    }
    ,
    CLOSE_NONTODAY_HEGDE_TODAY("\u5e73\u6628\u9501\u4eca"){

        @Override
        public CoreEnum.OffsetFlagEnum resolveOffsetFlag(SignalOperation operation, CoreField.ContractField contract, List<CoreField.TradeField> nonclosedTrades, String tradingDay) {
            if (operation.isOpen()) {
                return CoreEnum.OffsetFlagEnum.OF_Open;
            }
            this.checkNonclosedTrades(nonclosedTrades, contract);
            ArrayList<CoreField.TradeField> wrapList = new ArrayList<CoreField.TradeField>(nonclosedTrades);
            wrapList.sort((a, b) -> a.getTradeTimestamp() < b.getTradeTimestamp() ? -1 : 1);
            if (StringUtils.equals((CharSequence)tradingDay, (CharSequence)((CoreField.TradeField)wrapList.get(0)).getTradingDay())) {
                return CoreEnum.OffsetFlagEnum.OF_Open;
            }
            return CoreEnum.OffsetFlagEnum.OF_Close;
        }
    };

    private String name;

    private ClosingPolicy(String name) {
        this.name = name;
    }

    protected void checkNonclosedTrades(List<CoreField.TradeField> nonclosedTrades, CoreField.ContractField contract) {
        if (Objects.isNull(nonclosedTrades) || nonclosedTrades.isEmpty()) {
            throw new IllegalArgumentException("\u5e73\u4ed3\u65f6\uff0c\u6301\u4ed3\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (CoreField.TradeField trade : nonclosedTrades) {
            if (StringUtils.equals((CharSequence)trade.getContract().getContractId(), (CharSequence)contract.getContractId())) continue;
            throw new IllegalArgumentException(String.format("\u6301\u4ed3\u5217\u8868\u4e2d\u5305\u542b\u5176\u4ed6\u5408\u7ea6\u3002\u671f\u671b\uff1a%s, \u5b9e\u9645\uff1a%s", contract.getContractId(), trade.getContract().getContractId()));
        }
    }

    public abstract CoreEnum.OffsetFlagEnum resolveOffsetFlag(SignalOperation var1, CoreField.ContractField var2, List<CoreField.TradeField> var3, String var4);

    @Generated
    public String getName() {
        return this.name;
    }
}

