/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator.momentum;

import java.util.List;
import org.dromara.northstar.indicator.AbstractIndicator;
import org.dromara.northstar.indicator.Indicator;
import org.dromara.northstar.indicator.constant.ValueType;
import org.dromara.northstar.indicator.helper.HHVIndicator;
import org.dromara.northstar.indicator.helper.LLVIndicator;
import org.dromara.northstar.indicator.helper.SimpleValueIndicator;
import org.dromara.northstar.indicator.model.Configuration;
import org.dromara.northstar.indicator.model.Num;
import org.dromara.northstar.indicator.trend.SMAIndicator;

public class KDIndicator
extends AbstractIndicator
implements Indicator {
    private static String ERR_MSG = "KD\u6307\u6807\u662f\u4e00\u4e2a\u591a\u503c\u6307\u6807\uff0c\u4e0d\u80fd\u76f4\u63a5\u8c03\u7528\u8be5\u6307\u6807\u65b9\u6cd5\uff0c\u5e94\u8be5\u83b7\u53d6\u5177\u6709\u7684\u6307\u6807\u7ebf\u8fdb\u884c\u8c03\u7528";
    private Indicator rsv;
    private Indicator k;
    private Indicator d;

    public KDIndicator(Configuration cfg, int barCount, int m1, int m2) {
        super(cfg.toBuilder().visible(false).build());
        this.rsv = new RSVIndicator(cfg.toBuilder().visible(false).build(), barCount);
        this.k = new SMAIndicator(cfg.toBuilder().indicatorName(cfg.indicatorName() + "_k").build(), this.rsv, m1, 1);
        this.d = new SMAIndicator(cfg.toBuilder().indicatorName(cfg.indicatorName() + "_d").build(), this.k, m2, 1);
    }

    @Override
    protected Num evaluate(Num num) {
        return num;
    }

    @Override
    public Num get(int step) {
        throw new UnsupportedOperationException(ERR_MSG);
    }

    @Override
    public double value(int step) {
        throw new UnsupportedOperationException(ERR_MSG);
    }

    @Override
    public List<Num> getData() {
        throw new UnsupportedOperationException(ERR_MSG);
    }

    @Override
    public List<Indicator> dependencies() {
        return List.of(this.d);
    }

    public Indicator getK() {
        return this.k;
    }

    public Indicator getD() {
        return this.d;
    }

    public class RSVIndicator
    extends AbstractIndicator
    implements Indicator {
        private Indicator close;
        private Indicator high;
        private Indicator low;
        private Indicator llv;
        private Indicator hhv;

        public RSVIndicator(Configuration cfg, int barCount) {
            super(cfg);
            this.close = new SimpleValueIndicator(cfg.toBuilder().valueType(ValueType.CLOSE).visible(false).build());
            this.high = new SimpleValueIndicator(cfg.toBuilder().cacheLength(barCount).valueType(ValueType.HIGH).visible(false).build());
            this.low = new SimpleValueIndicator(cfg.toBuilder().cacheLength(barCount).valueType(ValueType.LOW).visible(false).build());
            this.llv = new LLVIndicator(cfg.toBuilder().visible(false).build(), this.low);
            this.hhv = new HHVIndicator(cfg.toBuilder().visible(false).build(), this.high);
        }

        @Override
        public List<Indicator> dependencies() {
            return List.of(this.close, this.llv, this.hhv);
        }

        @Override
        protected Num evaluate(Num num) {
            double val = (this.close.value(0) - this.llv.value(0)) / (this.hhv.value(0) - this.llv.value(0)) * 100.0;
            return Num.of(val, num.timestamp(), num.unstable());
        }
    }
}

