/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.strategy.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.dromara.northstar.common.TickDataAware;
import org.dromara.northstar.common.TransactionAware;
import org.dromara.northstar.common.constant.SignalOperation;
import org.dromara.northstar.common.utils.OrderUtils;
import org.dromara.northstar.strategy.IModuleContext;
import org.dromara.northstar.strategy.constant.PriceType;
import org.springframework.util.Assert;
import xyz.redtorch.pb.CoreField;

public class TradeIntent
implements TransactionAware,
TickDataAware {
    private IModuleContext context;
    @NonNull
    private final CoreField.ContractField contract;
    @NonNull
    private final SignalOperation operation;
    @NonNull
    private final PriceType priceType;
    private final double price;
    private final int volume;
    private final long timeout;
    private final Predicate<Double> priceDiffConditionToAbort;
    private Double initialPrice;
    private Optional<String> orderIdRef = Optional.empty();
    private int accVol;
    private boolean terminated;
    private long lastCancelReqTime;

    public TradeIntent(CoreField.ContractField contract, SignalOperation operation, PriceType priceType, double price, int volume, long timeout, Predicate<Double> priceDiffConditionToAbort) {
        Assert.noNullElements(List.of(contract, operation, priceType), (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((volume > 0 ? 1 : 0) != 0, (String)"\u624b\u6570\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
        Assert.isTrue((timeout > 0L ? 1 : 0) != 0, (String)"\u8ba2\u5355\u7b49\u5f85\u65f6\u957f\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
        this.contract = contract;
        this.operation = operation;
        this.priceType = priceType;
        this.price = price;
        this.volume = volume;
        this.timeout = timeout;
        this.priceDiffConditionToAbort = priceDiffConditionToAbort;
    }

    @Override
    public synchronized void onTick(CoreField.TickField tick) {
        if (!StringUtils.equals((CharSequence)tick.getUnifiedSymbol(), (CharSequence)this.contract.getUnifiedSymbol())) {
            return;
        }
        if (Objects.isNull(this.initialPrice)) {
            this.initialPrice = tick.getLastPrice();
        }
        if (Objects.nonNull(this.priceDiffConditionToAbort)) {
            double priceDiff = Math.abs(tick.getLastPrice() - this.initialPrice);
            this.terminated = this.priceDiffConditionToAbort.test(priceDiff);
            if (this.terminated) {
                this.context.getLogger().info("{} {} \u4ef7\u5dee\u4e2d\u6b62\u6761\u4ef6\u5df2\u7ecf\u6ee1\u8db3\uff0c\u5f53\u524d\u4ef7\u5dee\u4e3a{}", new Object[]{tick.getActionDay(), tick.getActionTime(), priceDiff});
            }
        }
        if (this.hasTerminated()) {
            this.context.getLogger().debug("\u4ea4\u6613\u610f\u56fe\u5df2\u7ec8\u6b62");
            return;
        }
        if (this.orderIdRef.isEmpty() && !this.context.getState().isOrdering()) {
            this.orderIdRef = this.context.submitOrderReq(this.contract, this.operation, this.priceType, this.volume - this.accVol, this.price);
        } else if (this.orderIdRef.isPresent() && this.context.isOrderWaitTimeout(this.orderIdRef.get(), this.timeout) && System.currentTimeMillis() - this.lastCancelReqTime > 3000L) {
            this.context.cancelOrder(this.orderIdRef.get());
            this.lastCancelReqTime = System.currentTimeMillis();
        }
    }

    @Override
    public synchronized void onOrder(CoreField.OrderField order) {
        this.orderIdRef.filter(id -> StringUtils.equals((CharSequence)id, (CharSequence)order.getOriginOrderId())).ifPresent(id -> {
            if (OrderUtils.isDoneOrder(order)) {
                this.orderIdRef = Optional.empty();
            }
        });
    }

    @Override
    public synchronized void onTrade(CoreField.TradeField trade) {
        this.accVol += trade.getVolume();
    }

    public boolean hasTerminated() {
        return this.terminated || this.accVol == this.volume;
    }

    public String toString() {
        return String.format("TradeIntent [contract=%s, operation=%s, priceType=%s, price=%s, volume=%s, timeout=%s]", new Object[]{this.contract.getContractId(), this.operation, this.priceType, this.price, this.volume, this.timeout});
    }

    @Generated
    public static TradeIntentBuilder builder() {
        return new TradeIntentBuilder();
    }

    @Generated
    public void setContext(IModuleContext context) {
        this.context = context;
    }

    @NonNull
    @Generated
    public CoreField.ContractField getContract() {
        return this.contract;
    }

    @NonNull
    @Generated
    public SignalOperation getOperation() {
        return this.operation;
    }

    @NonNull
    @Generated
    public PriceType getPriceType() {
        return this.priceType;
    }

    @Generated
    public double getPrice() {
        return this.price;
    }

    @Generated
    public int getVolume() {
        return this.volume;
    }

    @Generated
    public static class TradeIntentBuilder {
        @Generated
        private CoreField.ContractField contract;
        @Generated
        private SignalOperation operation;
        @Generated
        private PriceType priceType;
        @Generated
        private double price;
        @Generated
        private int volume;
        @Generated
        private long timeout;
        @Generated
        private Predicate<Double> priceDiffConditionToAbort;

        @Generated
        TradeIntentBuilder() {
        }

        @Generated
        public TradeIntentBuilder contract(CoreField.ContractField contract) {
            this.contract = contract;
            return this;
        }

        @Generated
        public TradeIntentBuilder operation(SignalOperation operation) {
            this.operation = operation;
            return this;
        }

        @Generated
        public TradeIntentBuilder priceType(PriceType priceType) {
            this.priceType = priceType;
            return this;
        }

        @Generated
        public TradeIntentBuilder price(double price) {
            this.price = price;
            return this;
        }

        @Generated
        public TradeIntentBuilder volume(int volume) {
            this.volume = volume;
            return this;
        }

        @Generated
        public TradeIntentBuilder timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public TradeIntentBuilder priceDiffConditionToAbort(Predicate<Double> priceDiffConditionToAbort) {
            this.priceDiffConditionToAbort = priceDiffConditionToAbort;
            return this;
        }

        @Generated
        public TradeIntent build() {
            return new TradeIntent(this.contract, this.operation, this.priceType, this.price, this.volume, this.timeout, this.priceDiffConditionToAbort);
        }

        @Generated
        public String toString() {
            return "TradeIntent.TradeIntentBuilder(contract=" + this.contract + ", operation=" + this.operation + ", priceType=" + this.priceType + ", price=" + this.price + ", volume=" + this.volume + ", timeout=" + this.timeout + ", priceDiffConditionToAbort=" + this.priceDiffConditionToAbort + ")";
        }
    }
}

