/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator;

import cn.hutool.core.lang.Assert;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.dromara.northstar.indicator.Indicator;
import org.dromara.northstar.indicator.model.Configuration;
import org.dromara.northstar.indicator.model.Num;
import org.dromara.northstar.indicator.model.RingArray;

public abstract class AbstractIndicator
implements Indicator {
    protected RingArray<Num> ringBuf;
    protected Configuration cfg;

    protected AbstractIndicator(Configuration cfg) {
        this.cfg = cfg;
        this.ringBuf = new RingArray(cfg.cacheLength());
    }

    @Override
    public void update(Num num) {
        if (this.ringBuf.size() > 0 && (num.timestamp() < this.get(0).timestamp() || num.timestamp() == this.get(0).timestamp() && !this.get(0).unstable())) {
            return;
        }
        Num updateNum = this.evaluate(num);
        if (!updateNum.isNaN()) {
            this.ringBuf.update(updateNum, updateNum.unstable());
        }
    }

    protected abstract Num evaluate(Num var1);

    @Override
    public Num get(int step) {
        Assert.isTrue((step <= 0 ? 1 : 0) != 0, (String)"\u56de\u6eaf\u6b65\u957f\u4e0d\u80fd\u662f\u6b63\u6570", (Object[])new Object[0]);
        Assert.isTrue((step > -this.cfg.cacheLength() ? 1 : 0) != 0, (String)"\u56de\u6eaf\u957f\u5ea6\u8d85\u8fc7\u6307\u6807\u7f13\u5b58\u5927\u5c0f", (Object[])new Object[0]);
        if (Objects.isNull(this.ringBuf.get(step))) {
            return Num.NaN();
        }
        return this.ringBuf.get(step);
    }

    @Override
    public double value(int step) {
        return this.get(step).value();
    }

    @Override
    public boolean isReady() {
        return this.ringBuf.length() == this.ringBuf.size();
    }

    @Override
    public List<Num> getData() {
        return Stream.of(this.ringBuf.toArray()).filter(Objects::nonNull).map(Num.class::cast).toList();
    }

    @Override
    public Configuration getConfiguration() {
        return this.cfg;
    }

    @Override
    public List<Indicator> dependencies() {
        return Collections.emptyList();
    }
}

