/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.strategy.tester;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.northstar.common.IGatewayService;
import org.dromara.northstar.common.IModuleService;
import org.dromara.northstar.common.constant.ChannelType;
import org.dromara.northstar.common.constant.ClosingPolicy;
import org.dromara.northstar.common.constant.ConnectionState;
import org.dromara.northstar.common.constant.ModuleType;
import org.dromara.northstar.common.constant.ModuleUsage;
import org.dromara.northstar.common.model.ComponentAndParamsPair;
import org.dromara.northstar.common.model.ComponentField;
import org.dromara.northstar.common.model.ComponentMetaInfo;
import org.dromara.northstar.common.model.ContractSimpleInfo;
import org.dromara.northstar.common.model.DynamicParams;
import org.dromara.northstar.common.model.ModuleAccountDescription;
import org.dromara.northstar.common.model.ModuleDescription;
import org.dromara.northstar.common.model.ModuleRuntimeDescription;
import org.dromara.northstar.gateway.Contract;
import org.dromara.northstar.gateway.IContractManager;
import org.dromara.northstar.gateway.MarketGateway;
import org.dromara.northstar.gateway.TradeGateway;
import org.dromara.northstar.strategy.IModule;
import org.dromara.northstar.strategy.tester.GatewayBuilder;
import org.dromara.northstar.strategy.tester.ModuleBuilder;
import org.dromara.northstar.strategy.tester.ModuleTesterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import xyz.redtorch.pb.CoreField;

public abstract class AbstractTester {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTester.class);
    protected IContractManager contractMgr;
    protected GatewayBuilder gatewayBuilder;
    protected ModuleBuilder moduleBuilder;
    protected IGatewayService gatewayService;
    protected IModuleService moduleService;
    protected ModuleTesterContext ctx;

    protected AbstractTester(GatewayBuilder gatewayBuilder, ModuleBuilder moduleBuilder, IContractManager contractMgr, IGatewayService gatewayService, IModuleService moduleService) {
        this.contractMgr = contractMgr;
        this.gatewayBuilder = gatewayBuilder;
        this.moduleBuilder = moduleBuilder;
        this.gatewayService = gatewayService;
        this.moduleService = moduleService;
    }

    public abstract DynamicParams strategyParams(ContractSimpleInfo var1);

    public abstract ComponentMetaInfo strategy();

    public abstract int[] testPeriods();

    private List<ComponentField> convertParams(DynamicParams params) {
        Map<String, ComponentField> fieldMap = params.getMetaInfo();
        for (Map.Entry<String, ComponentField> e : fieldMap.entrySet()) {
            PropertyDescriptor prop = BeanUtils.getPropertyDescriptor(params.getClass(), (String)e.getKey());
            try {
                Object value = prop.getReadMethod().invoke((Object)params, new Object[0]);
                e.getValue().setValue(value);
            }
            catch (Exception ex) {
                log.error("", (Throwable)ex);
            }
        }
        return fieldMap.values().stream().toList();
    }

    public void start() {
        String currentSymbol = this.load();
        for (String symbol : this.ctx.testSymbols()) {
            if (StringUtils.isNotEmpty((CharSequence)currentSymbol) && !StringUtils.equals((CharSequence)symbol, (CharSequence)currentSymbol)) continue;
            currentSymbol = "";
            this.save(symbol);
            String idxSymbol = symbol + "0000";
            Contract c = this.contractMgr.getContract(ChannelType.PLAYBACK, idxSymbol);
            CoreField.ContractField cf = c.contractField();
            ContractSimpleInfo csi = ContractSimpleInfo.builder().name(cf.getName()).channelType(ChannelType.PLAYBACK).unifiedSymbol(cf.getUnifiedSymbol()).value(c.identifier().value()).build();
            MarketGateway mktGateway = this.gatewayBuilder.createPlaybackGateway(csi, this.ctx);
            TradeGateway tdGateway = this.gatewayBuilder.createSimGateway(mktGateway);
            tdGateway.connect();
            this.gatewayService.simMoneyIO(tdGateway.gatewayId(), this.ctx.symbolTestAmount().get(symbol));
            ModuleAccountDescription mad = ModuleAccountDescription.builder().accountGatewayId(tdGateway.gatewayId()).bindedContracts(List.of(csi)).build();
            ComponentAndParamsPair strategySettings = ComponentAndParamsPair.builder().componentMeta(this.strategy()).initParams(this.convertParams(this.strategyParams(csi))).build();
            List<IModule> testModules = IntStream.of(this.testPeriods()).mapToObj(min -> this.moduleBuilder.createModule(ModuleDescription.builder().moduleName(String.format("%s%d\u5206\u949f", symbol, min)).initBalance(this.ctx.symbolTestAmount().get(symbol).intValue()).usage(ModuleUsage.PLAYBACK).type(ModuleType.SPECULATION).closingPolicy(ClosingPolicy.FIRST_IN_FIRST_OUT).numOfMinPerBar(min).moduleCacheDataSize(5000).strategySetting(strategySettings).moduleAccountSettingsDescription(List.of(mad)).build())).toList();
            mktGateway.connect();
            while (mktGateway.getConnectionState() != ConnectionState.DISCONNECTED) {
                this.pause(5);
                log.info("{} \u6570\u636e\u9884\u70ed\u4e2d", (Object)idxSymbol);
            }
            testModules.forEach(m -> m.setEnabled(true));
            this.pause(1);
            mktGateway.connect();
            while (mktGateway.getConnectionState() != ConnectionState.DISCONNECTED) {
                this.pause(60);
                log.info("{} \u56de\u6d4b\u4e2d", (Object)idxSymbol);
            }
            this.pause(30);
            for (IModule m2 : testModules) {
                ModuleRuntimeDescription mrd = m2.getModuleContext().getRuntimeDescription(false);
                double totalEarning = mrd.getAccountRuntimeDescription().getAccCloseProfit() - mrd.getAccountRuntimeDescription().getAccCommission();
                double earningRiskRate = totalEarning / Math.abs(mrd.getAccountRuntimeDescription().getMaxDrawback());
                if (!(mrd.getAccountRuntimeDescription().getAccCloseProfit() < 0.0) && !(mrd.getAccountRuntimeDescription().getMaxDrawbackPercentage() > 0.5) && !(earningRiskRate < 2.0)) continue;
                this.moduleService.removeModule(m2.getName());
            }
        }
        this.save("");
    }

    private void save(String symbol) {
        File saveFile = new File("data/module-tester/" + this.strategy().getName());
        try {
            FileUtils.write((File)saveFile, (CharSequence)symbol, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
    }

    private String load() {
        File saveFile = new File("data/module-tester/" + this.strategy().getName());
        try {
            if (saveFile.exists()) {
                return FileUtils.readFileToString((File)saveFile, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        return "";
    }

    private void pause(int sec) {
        try {
            Thread.sleep((long)sec * 1000L);
        }
        catch (InterruptedException e) {
            log.warn("", (Throwable)e);
        }
    }
}

