/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.strategy.tester;

import com.alibaba.fastjson2.JSONObject;
import java.util.List;
import org.dromara.northstar.common.IGatewayService;
import org.dromara.northstar.common.ObjectManager;
import org.dromara.northstar.common.constant.ChannelType;
import org.dromara.northstar.common.constant.DateTimeConstant;
import org.dromara.northstar.common.constant.GatewayUsage;
import org.dromara.northstar.common.model.ContractSimpleInfo;
import org.dromara.northstar.common.model.GatewayDescription;
import org.dromara.northstar.common.model.Identifier;
import org.dromara.northstar.gateway.Gateway;
import org.dromara.northstar.gateway.MarketGateway;
import org.dromara.northstar.gateway.TradeGateway;
import org.dromara.northstar.strategy.tester.ModuleTesterContext;

public class GatewayBuilder {
    private IGatewayService gatewayService;
    private ObjectManager<Gateway> gatewayMgr;

    public GatewayBuilder(IGatewayService gatewayService, ObjectManager<Gateway> gatewayMgr) {
        this.gatewayService = gatewayService;
        this.gatewayMgr = gatewayMgr;
    }

    public MarketGateway createPlaybackGateway(ContractSimpleInfo csi, ModuleTesterContext ctx) {
        String gatewayId = "\u5386\u53f2\u56de\u653e_" + csi.getName();
        JSONObject settings = new JSONObject();
        settings.put((Object)"preStartDate", (Object)ctx.preStartDate().format(DateTimeConstant.D_FORMAT_INT_FORMATTER));
        settings.put((Object)"startDate", (Object)ctx.startDate().format(DateTimeConstant.D_FORMAT_INT_FORMATTER));
        settings.put((Object)"endDate", (Object)ctx.endDate().format(DateTimeConstant.D_FORMAT_INT_FORMATTER));
        settings.put((Object)"precision", (Object)ctx.precision());
        settings.put((Object)"speed", (Object)ctx.speed());
        settings.put((Object)"playContracts", List.of(csi));
        GatewayDescription gd = GatewayDescription.builder().gatewayId(gatewayId).gatewayUsage(GatewayUsage.MARKET_DATA).channelType(ChannelType.PLAYBACK).subscribedContracts(List.of(csi)).settings(settings).build();
        this.gatewayService.createGateway(gd);
        return (MarketGateway)this.gatewayMgr.get(Identifier.of(gatewayId));
    }

    public TradeGateway createSimGateway(MarketGateway mktGateway) {
        String gatewayId = "\u6a21\u62df\u8d26\u6237_" + mktGateway.gatewayDescription().getSubscribedContracts().get(0).getName();
        GatewayDescription gd = GatewayDescription.builder().gatewayId(gatewayId).gatewayUsage(GatewayUsage.TRADE).channelType(ChannelType.SIM).bindedMktGatewayId(mktGateway.gatewayId()).settings(new JSONObject()).build();
        this.gatewayService.createGateway(gd);
        return (TradeGateway)this.gatewayMgr.get(Identifier.of(gatewayId));
    }
}

