/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.model;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.dromara.northstar.common.constant.FieldType;
import org.dromara.northstar.common.model.ComponentField;
import org.dromara.northstar.common.model.Setting;

public abstract class DynamicParams {
    public DynamicParams resolveFromSource(Map<String, ComponentField> fieldMap) throws Exception {
        if (fieldMap == null) {
            throw new IllegalStateException("\u5c5e\u6027\u63cf\u8ff0\u4e3a\u7a7a");
        }
        for (Map.Entry<String, ComponentField> e : fieldMap.entrySet()) {
            Field f = this.getClass().getDeclaredField(e.getKey());
            ComponentField cf = e.getValue();
            boolean flag = f.canAccess(this);
            f.setAccessible(true);
            if (FieldType.NUMBER == cf.getType()) {
                if (f.getType() == Integer.TYPE) {
                    f.setInt(this, cf.getValue() == null ? 0 : (cf.getValue() instanceof String ? Integer.parseInt((String)cf.getValue()) : (Integer)cf.getValue()));
                } else if (f.getType() == Long.TYPE) {
                    f.setLong(this, cf.getValue() == null ? 0L : (cf.getValue() instanceof String ? Long.parseLong((String)cf.getValue()) : (Long)cf.getValue()));
                } else if (f.getType() == Float.TYPE) {
                    f.setFloat(this, cf.getValue() == null ? 0.0f : (cf.getValue() instanceof String ? Float.parseFloat((String)cf.getValue()) : ((Float)cf.getValue()).floatValue()));
                } else if (f.getType() == Double.TYPE) {
                    f.setDouble(this, cf.getValue() == null ? 0.0 : (cf.getValue() instanceof String ? Double.parseDouble((String)cf.getValue()) : (Double)cf.getValue()));
                } else if (f.getType() == Short.TYPE) {
                    f.setShort(this, cf.getValue() == null ? (short)0 : (cf.getValue() instanceof String ? Short.parseShort((String)cf.getValue()) : (Short)cf.getValue()));
                }
            } else if (f.getType() == Boolean.TYPE) {
                f.set(this, Boolean.parseBoolean((String)cf.getValue()));
            } else {
                f.set(this, cf.getValue());
            }
            f.setAccessible(flag);
        }
        return this;
    }

    public Map<String, ComponentField> getMetaInfo() {
        Field[] fs = this.getClass().getDeclaredFields();
        HashMap<String, ComponentField> fieldMap = new HashMap<String, ComponentField>();
        for (Field f : fs) {
            if (!f.isAnnotationPresent(Setting.class)) continue;
            Setting anno = f.getAnnotation(Setting.class);
            String fieldName = f.getName();
            String label = anno.label();
            int order = anno.order();
            String unit = anno.unit();
            String[] options = anno.options();
            String[] optionsVal = anno.optionsVal();
            FieldType type = anno.type();
            String placeholder = anno.placeholder();
            boolean required = anno.required();
            fieldMap.put(fieldName, new ComponentField(label, fieldName, order, type, null, unit, options, optionsVal, placeholder, required));
        }
        return fieldMap;
    }
}

