/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.gateway.time;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dromara.northstar.gateway.TradeTimeDefinition;
import org.dromara.northstar.gateway.model.PeriodSegment;

public class PeriodHelper {
    private List<LocalTime> baseTimeFrame = new ArrayList<LocalTime>(256);
    private Set<LocalTime> endOfSections = new HashSet<LocalTime>();

    public PeriodHelper(int numbersOfMinPerPeriod, TradeTimeDefinition tradeTimeDefinition) {
        this(numbersOfMinPerPeriod, tradeTimeDefinition, true);
    }

    public PeriodHelper(int numbersOfMinPerPeriod, TradeTimeDefinition tradeTimeDefinition, boolean exclusiveOpening) {
        List<PeriodSegment> tradeTimeSegments = tradeTimeDefinition.tradeTimeSegments();
        LocalTime opening = tradeTimeSegments.get(0).startOfSegment();
        LocalTime ending = tradeTimeSegments.get(tradeTimeSegments.size() - 1).endOfSegment();
        LocalTime t = opening.plusMinutes(1L);
        if (!exclusiveOpening) {
            this.baseTimeFrame.add(opening);
        }
        int minCount = 1;
        while (!t.equals(opening)) {
            for (PeriodSegment ps : tradeTimeSegments) {
                this.endOfSections.add(ps.endOfSegment());
                while (ps.withinPeriod(t)) {
                    if (!t.equals(opening) && minCount == numbersOfMinPerPeriod && !t.equals(ending)) {
                        this.baseTimeFrame.add(t);
                        minCount = 1;
                    } else {
                        if (t.equals(ending)) {
                            this.baseTimeFrame.add(t);
                            return;
                        }
                        ++minCount;
                    }
                    t = t.plusMinutes(1L);
                }
            }
            t = t.plusMinutes(1L);
        }
    }

    public List<LocalTime> getRunningBaseTimeFrame() {
        return this.baseTimeFrame;
    }

    public boolean isEndOfSection(LocalTime t) {
        return this.endOfSections.contains(t);
    }
}

