/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator.volatility;

import java.util.List;
import org.dromara.northstar.indicator.AbstractIndicator;
import org.dromara.northstar.indicator.Indicator;
import org.dromara.northstar.indicator.helper.DiffIndicator;
import org.dromara.northstar.indicator.helper.StandardDeviationIndicator;
import org.dromara.northstar.indicator.helper.SumIndicator;
import org.dromara.northstar.indicator.model.Configuration;
import org.dromara.northstar.indicator.model.Num;
import org.dromara.northstar.indicator.trend.MAIndicator;

public class BOLLIndicator
extends AbstractIndicator
implements Indicator {
    private Indicator mid;
    private Indicator std;
    private Indicator upper;
    private Indicator lower;

    public BOLLIndicator(Configuration cfg, int barCount, double multipler) {
        super(cfg.toBuilder().visible(false).build());
        this.mid = new MAIndicator(cfg.toBuilder().indicatorName("BOLL_mid").numOfUnits(barCount).build(), barCount);
        this.std = new StandardDeviationIndicator(cfg.toBuilder().indicatorName("BOLL_std").build(), barCount);
        this.upper = new SumIndicator(cfg.toBuilder().indicatorName("BOLL_upper").numOfUnits(barCount).build(), this.mid, 1.0, this.std, multipler);
        this.lower = new DiffIndicator(cfg.toBuilder().indicatorName("BOLL_lower").numOfUnits(barCount).build(), this.mid, 1.0, this.std, multipler);
    }

    @Override
    public List<Indicator> dependencies() {
        return List.of(this.mid, this.upper, this.lower);
    }

    @Override
    protected Num evaluate(Num num) {
        return this.std.get(0);
    }

    @Override
    public Num get(int step) {
        return Num.NaN();
    }

    public Indicator getMid() {
        return this.mid;
    }

    public Indicator getUpper() {
        return this.upper;
    }

    public Indicator getLower() {
        return this.lower;
    }
}

