/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.gateway.time;

import java.time.Duration;
import java.time.LocalTime;
import java.util.List;
import java.util.Optional;

public class BarClock {
    private final List<LocalTime> baseTimeLine;
    private int cursor;

    public BarClock(List<LocalTime> baseTimeLine) {
        this.baseTimeLine = baseTimeLine;
    }

    public boolean adjustTime(LocalTime time) {
        LocalTime timeBucket;
        Optional<Duration> timeDiffOpt = this.baseTimeLine.stream().map(t -> Duration.between(time, t)).filter(d -> !d.isNegative()).min((d1, d2) -> d1.compareTo((Duration)d2));
        if (timeDiffOpt.isPresent() && !(timeBucket = time.plus(timeDiffOpt.get())).equals(this.currentTimeBucket())) {
            this.cursor = this.baseTimeLine.indexOf(timeBucket);
            return true;
        }
        return false;
    }

    public LocalTime currentTimeBucket() {
        return this.baseTimeLine.get(this.cursor);
    }

    public LocalTime next() {
        this.cursor = (this.cursor + 1) % this.baseTimeLine.size();
        return this.currentTimeBucket();
    }
}

