/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator.model;

import java.util.Optional;
import org.dromara.northstar.indicator.constant.PeriodUnit;
import org.dromara.northstar.indicator.constant.ValueType;
import org.springframework.util.Assert;
import xyz.redtorch.pb.CoreField;

public record Configuration(String indicatorName, CoreField.ContractField contract, int numOfUnits, PeriodUnit period, ValueType valueType, int cacheLength, boolean ifPlotPerBar, boolean visible) {
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder b = Configuration.builder();
        b.indicatorName = this.indicatorName;
        b.contract = this.contract;
        b.numOfUnits = this.numOfUnits;
        b.period = this.period;
        b.valueType = this.valueType;
        b.cacheLength = this.cacheLength;
        b.ifPlotPerBar = this.ifPlotPerBar;
        return b;
    }

    public static class Builder {
        private String indicatorName;
        private CoreField.ContractField contract;
        private int numOfUnits = 1;
        private PeriodUnit period = PeriodUnit.MINUTE;
        private ValueType valueType = ValueType.CLOSE;
        private int cacheLength = 16;
        private boolean ifPlotPerBar;
        private boolean visible = true;

        public Builder indicatorName(String name) {
            this.indicatorName = name;
            return this;
        }

        public Builder contract(CoreField.ContractField contract) {
            this.contract = contract;
            return this;
        }

        public Builder numOfUnits(int numOfUnits) {
            this.numOfUnits = numOfUnits;
            return this;
        }

        public Builder period(PeriodUnit period) {
            this.period = period;
            return this;
        }

        public Builder valueType(ValueType valueType) {
            this.valueType = valueType;
            return this;
        }

        public Builder cacheLength(int cacheLength) {
            this.cacheLength = cacheLength;
            return this;
        }

        public Builder ifPlotPerBar(boolean ifPlotPerBar) {
            this.ifPlotPerBar = ifPlotPerBar;
            return this;
        }

        public Builder visible(boolean visible) {
            this.visible = visible;
            return this;
        }

        public Configuration build() {
            Assert.notNull((Object)this.contract, (String)(Optional.ofNullable(this.indicatorName).orElse("") + " \u672a\u7ed1\u5b9a\u8ba1\u7b97\u5408\u7ea6"));
            return new Configuration(this.indicatorName, this.contract, this.numOfUnits, this.period, this.valueType, this.cacheLength, this.ifPlotPerBar, this.visible);
        }
    }
}

