/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.dromara.northstar.common.constant.ChannelType;
import org.dromara.northstar.common.constant.DateTimeConstant;
import org.dromara.northstar.common.constant.TickType;
import xyz.redtorch.pb.CoreEnum;
import xyz.redtorch.pb.CoreField;

public class TestFieldFactory {
    private String gatewayId;

    public TestFieldFactory(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public CoreField.SubmitOrderReqField makeOrderReq(String symbol, CoreEnum.DirectionEnum direction, CoreEnum.OffsetFlagEnum offsetFlag, int openVol, double price, double stopPrice) {
        return CoreField.SubmitOrderReqField.newBuilder().setOriginOrderId(UUID.randomUUID().toString()).setContract(this.makeContract(symbol)).setDirection(direction).setOffsetFlag(offsetFlag).setOrderPriceType(CoreEnum.OrderPriceTypeEnum.OPT_LimitPrice).setVolume(openVol).setHedgeFlag(CoreEnum.HedgeFlagEnum.HF_Speculation).setTimeCondition(CoreEnum.TimeConditionEnum.TC_GFD).setVolumeCondition(CoreEnum.VolumeConditionEnum.VC_AV).setForceCloseReason(CoreEnum.ForceCloseReasonEnum.FCR_NotForceClose).setContingentCondition(CoreEnum.ContingentConditionEnum.CC_Immediately).setMinVolume(1).setGatewayId(this.gatewayId).setStopPrice(stopPrice).setPrice(price).build();
    }

    public CoreField.CancelOrderReqField makeCancelReq(CoreField.SubmitOrderReqField orderReq) {
        return CoreField.CancelOrderReqField.newBuilder().setGatewayId(orderReq.getGatewayId()).setOriginOrderId(orderReq.getOriginOrderId()).build();
    }

    public CoreField.ContractField makeContract(String symbol) {
        return CoreField.ContractField.newBuilder().setGatewayId(this.gatewayId).setChannelType(ChannelType.SIM.toString()).setCurrency(CoreEnum.CurrencyEnum.CNY).setContractId(symbol + "@SHFE@FUTURES@" + this.gatewayId).setExchange(CoreEnum.ExchangeEnum.SHFE).setFullName(symbol).setThirdPartyId(symbol + "@" + ChannelType.SIM).setLongMarginRatio(0.08).setShortMarginRatio(0.08).setMultiplier(10.0).setPriceTick(1.0).setCommissionRate(1.0E-4).setProductClass(CoreEnum.ProductClassEnum.FUTURES).setUnifiedSymbol(symbol + "@SHFE@FUTURES").setSymbol(symbol).build();
    }

    public CoreField.TickField makeTickField(String symbol, double price) {
        return CoreField.TickField.newBuilder().setGatewayId(this.gatewayId).setChannelType(ChannelType.SIM.toString()).setUnifiedSymbol(symbol + "@SHFE@FUTURES").setActionDay(LocalDate.now().format(DateTimeConstant.D_FORMAT_INT_FORMATTER)).setActionTime(LocalTime.now().format(DateTimeConstant.T_FORMAT_WITH_MS_INT_FORMATTER)).setActionTimestamp(System.currentTimeMillis()).addAllAskPrice(List.of(Double.valueOf(price + 1.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0))).addAllBidPrice(List.of(Double.valueOf(price - 1.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0))).setLastPrice(price).setStatus(TickType.NORMAL_TICK.getCode()).setTradingDay(LocalDate.now().format(DateTimeConstant.D_FORMAT_INT_FORMATTER)).build();
    }

    public CoreField.BarField makeBarField(String symbol, double price, double deltaRange, LocalDateTime ldt) {
        double dif1 = ThreadLocalRandom.current().nextDouble(deltaRange);
        double dif2 = ThreadLocalRandom.current().nextDouble(deltaRange);
        double dif3 = ThreadLocalRandom.current().nextDouble(deltaRange);
        return CoreField.BarField.newBuilder().setGatewayId(this.gatewayId).setChannelType(ChannelType.SIM.toString()).setUnifiedSymbol(symbol).setUnifiedSymbol(symbol + "@SHFE@FUTURES").setActionDay(ldt.toLocalDate().format(DateTimeConstant.D_FORMAT_INT_FORMATTER)).setActionTime(ldt.toLocalTime().format(DateTimeConstant.T_FORMAT_FORMATTER)).setActionTimestamp(ldt.toInstant(ZoneOffset.ofHours(8)).toEpochMilli()).setTradingDay(ldt.toLocalDate().format(DateTimeConstant.D_FORMAT_INT_FORMATTER)).setOpenPrice(price + dif1).setHighPrice(price + Math.max(dif3, Math.max(dif1, dif2))).setLowPrice(price + Math.min(dif3, Math.min(dif1, dif2))).setClosePrice(price).build();
    }

    public CoreField.GatewaySettingField makeGatewaySetting() {
        return CoreField.GatewaySettingField.newBuilder().setGatewayId(this.gatewayId).build();
    }

    public CoreField.OrderField makeOrderField(String symbol, double price, int vol, CoreEnum.DirectionEnum dir, CoreEnum.OffsetFlagEnum offset) {
        return CoreField.OrderField.newBuilder().setOriginOrderId(UUID.randomUUID().toString()).setContract(this.makeContract(symbol)).setPrice(price).setTotalVolume(vol).setDirection(dir).setOffsetFlag(offset).setTradingDay(LocalDate.now().format(DateTimeConstant.D_FORMAT_INT_FORMATTER)).build();
    }

    public CoreField.OrderField makeOrderField(String symbol, double price, int vol, CoreEnum.DirectionEnum dir, CoreEnum.OffsetFlagEnum offset, CoreEnum.OrderStatusEnum status) {
        return CoreField.OrderField.newBuilder().setOriginOrderId(UUID.randomUUID().toString()).setContract(this.makeContract(symbol)).setPrice(price).setTotalVolume(vol).setDirection(dir).setOffsetFlag(offset).setOrderStatus(status).setTradingDay(LocalDate.now().format(DateTimeConstant.D_FORMAT_INT_FORMATTER)).setGatewayId(this.gatewayId).build();
    }

    public CoreField.TradeField makeTradeField(String symbol, double price, int vol, CoreEnum.DirectionEnum dir, CoreEnum.OffsetFlagEnum offset) {
        return CoreField.TradeField.newBuilder().setOriginOrderId(UUID.randomUUID().toString()).setContract(this.makeContract(symbol)).setPrice(price).setVolume(vol).setDirection(dir).setOffsetFlag(offset).setTradingDay(LocalDate.now().format(DateTimeConstant.D_FORMAT_INT_FORMATTER)).setGatewayId(this.gatewayId).build();
    }

    public CoreField.TradeField makeTradeField(String symbol, double price, int vol, CoreEnum.DirectionEnum dir, CoreEnum.OffsetFlagEnum offset, String tradingDay) {
        return CoreField.TradeField.newBuilder().setOriginOrderId(UUID.randomUUID().toString()).setContract(this.makeContract(symbol)).setPrice(price).setVolume(vol).setDirection(dir).setOffsetFlag(offset).setTradingDay(tradingDay).setTradeTimestamp(LocalDateTime.of(LocalDate.parse(tradingDay, DateTimeConstant.D_FORMAT_INT_FORMATTER), LocalTime.now()).toInstant(ZoneOffset.ofHours(8)).toEpochMilli()).setGatewayId(this.gatewayId).build();
    }
}

