/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.gateway;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.dromara.northstar.common.GatewaySettings;
import org.dromara.northstar.common.IDataServiceManager;
import org.dromara.northstar.common.constant.ChannelType;
import org.dromara.northstar.common.model.ComponentField;
import org.dromara.northstar.common.model.DynamicParams;
import org.dromara.northstar.gateway.GatewayFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayMetaProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GatewayMetaProvider.class);
    private Map<ChannelType, GatewaySettings> settingsMap = new EnumMap<ChannelType, GatewaySettings>(ChannelType.class);
    private Map<ChannelType, GatewayFactory> factoryMap = new EnumMap<ChannelType, GatewayFactory>(ChannelType.class);
    private Map<ChannelType, IDataServiceManager> mdRepoMap = new EnumMap<ChannelType, IDataServiceManager>(ChannelType.class);

    public Collection<ComponentField> getSettings(ChannelType channelType) {
        return ((DynamicParams)((Object)this.settingsMap.get((Object)channelType))).getMetaInfo().values();
    }

    public GatewayFactory getFactory(ChannelType channelType) {
        if (!this.factoryMap.containsKey((Object)channelType)) {
            throw new IllegalStateException("\u6ca1\u6709\u8be5\u6e20\u9053\u7684\u7f51\u5173\u7c7b\u578b\uff1a" + channelType);
        }
        return this.factoryMap.get((Object)channelType);
    }

    public IDataServiceManager getMarketDataRepo(ChannelType channelType) {
        if (this.mdRepoMap.containsKey((Object)channelType)) {
            return this.mdRepoMap.get((Object)channelType);
        }
        throw new IllegalStateException("\u6ca1\u6709\u8be5\u6e20\u9053\u7684\u6570\u636e\u6765\u6e90\uff1a" + channelType);
    }

    public void add(ChannelType channelType, GatewaySettings settings, GatewayFactory factory, IDataServiceManager dsMgr) {
        log.info("\u6ce8\u518c [{}] \u6e20\u9053\u5143\u4fe1\u606f", (Object)channelType);
        if (Objects.nonNull(settings)) {
            this.settingsMap.put(channelType, settings);
        }
        if (Objects.nonNull(factory)) {
            this.factoryMap.put(channelType, factory);
        }
        if (Objects.nonNull(dsMgr)) {
            this.mdRepoMap.put(channelType, dsMgr);
        }
    }

    public List<ChannelType> availableChannel() {
        HashSet<ChannelType> channels = new HashSet<ChannelType>();
        channels.addAll(this.factoryMap.keySet());
        channels.addAll(this.settingsMap.keySet());
        return channels.stream().sorted().toList();
    }
}

