/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.gateway.time;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.List;
import org.dromara.northstar.gateway.TradeTimeDefinition;
import org.dromara.northstar.gateway.time.PeriodHelper;
import xyz.redtorch.pb.CoreField;

public class OpenningMinuteClock {
    private List<LocalTime> timeFrame;
    private PeriodHelper helper;

    public OpenningMinuteClock(TradeTimeDefinition tradeTimeDefinition) {
        this.helper = new PeriodHelper(1, tradeTimeDefinition);
        this.timeFrame = this.helper.getRunningBaseTimeFrame();
    }

    public LocalDateTime barMinute(CoreField.TickField tick) {
        LocalDateTime tickDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(tick.getActionTimestamp()), ZoneId.systemDefault());
        return tickDateTime.withSecond(0).withNano(0).plusMinutes(1L);
    }

    public boolean isValidOpenningTick(CoreField.TickField tick) {
        LocalDateTime ldt = this.barMinute(tick);
        LocalTime barTime = ldt.toLocalTime();
        return this.timeFrame.indexOf(barTime) >= 0;
    }

    public boolean isEndOfSection(LocalTime t) {
        return this.helper.isEndOfSection(t);
    }
}

