/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator.helper;

import java.util.List;
import org.dromara.northstar.indicator.AbstractIndicator;
import org.dromara.northstar.indicator.Indicator;
import org.dromara.northstar.indicator.model.Configuration;
import org.dromara.northstar.indicator.model.Num;

public class DiffIndicator
extends AbstractIndicator
implements Indicator {
    private Indicator line1;
    private Indicator line2;
    private double multiplier1;
    private double multiplier2;

    public DiffIndicator(Configuration cfg, Indicator line1, Indicator line2) {
        this(cfg, line1, 1.0, line2, 1.0);
    }

    public DiffIndicator(Configuration cfg, Indicator line1, double multiplier1, Indicator line2, double multiplier2) {
        super(cfg);
        this.line1 = line1;
        this.line2 = line2;
        this.multiplier1 = multiplier1;
        this.multiplier2 = multiplier2;
    }

    @Override
    protected Num evaluate(Num num) {
        return Num.of(this.line1.value(0) * this.multiplier1 - this.line2.value(0) * this.multiplier2, num.timestamp(), num.unstable());
    }

    @Override
    public List<Indicator> dependencies() {
        return List.of(this.line1, this.line2);
    }
}

