/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator.trend;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.dromara.northstar.indicator.AbstractIndicator;
import org.dromara.northstar.indicator.Indicator;
import org.dromara.northstar.indicator.model.Configuration;
import org.dromara.northstar.indicator.model.Num;
import org.dromara.northstar.indicator.model.RingArray;

public class MAIndicator
extends AbstractIndicator
implements Indicator {
    private RingArray<Num> sample;
    private double sum;
    private Indicator srcIndicator;

    public MAIndicator(Configuration cfg, int barCount) {
        super(cfg);
        this.sample = new RingArray(barCount);
    }

    public MAIndicator(Configuration cfg, Indicator srcIndicator, int barCount) {
        this(cfg, barCount);
        this.srcIndicator = srcIndicator;
    }

    @Override
    protected Num evaluate(Num num) {
        Num newVal;
        Num num2 = newVal = Objects.isNull(this.srcIndicator) ? num : this.srcIndicator.get(0);
        if (newVal.isNaN()) {
            return newVal;
        }
        this.sample.update(newVal, newVal.unstable()).ifPresent(val -> this.sum -= val.value());
        this.sum += newVal.value();
        return Num.of(this.sum / (double)this.sample.size(), num.timestamp(), num.unstable());
    }

    @Override
    public List<Indicator> dependencies() {
        if (Objects.isNull(this.srcIndicator)) {
            return Collections.emptyList();
        }
        return List.of(this.srcIndicator);
    }
}

