/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.strategy;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import lombok.Generated;
import org.dromara.northstar.common.TickDataAware;
import org.dromara.northstar.common.utils.FieldUtils;
import org.dromara.northstar.strategy.IModuleContext;
import org.dromara.northstar.strategy.IModuleStrategyContext;
import org.dromara.northstar.strategy.MergedBarListener;
import org.dromara.northstar.strategy.TradeStrategy;
import org.slf4j.Logger;
import xyz.redtorch.pb.CoreField;

public abstract class AbstractStrategy
implements TradeStrategy {
    protected JSONObject storeObject;
    protected IModuleStrategyContext ctx;
    protected Map<String, TickHandler> tickHandlerMap = new HashMap<String, TickHandler>();
    protected Map<String, BarHandler> barHandlerMap = new HashMap<String, BarHandler>();
    protected Logger log;
    protected int numOfBarsToPrepare;
    private Queue<CoreField.BarField> barCache = new LinkedList<CoreField.BarField>();

    @Override
    public void onOrder(CoreField.OrderField order) {
    }

    @Override
    public void onTrade(CoreField.TradeField trade) {
        String unifiedSymbol = trade.getContract().getUnifiedSymbol();
        if (this.log.isInfoEnabled()) {
            this.log.info("\u6a21\u7ec4\u6210\u4ea4 [{} {} {} \u64cd\u4f5c\uff1a{}{} {}\u624b {}]", new Object[]{unifiedSymbol, trade.getTradeDate(), trade.getTradeTime(), FieldUtils.chn(trade.getDirection()), FieldUtils.chn(trade.getOffsetFlag()), trade.getVolume(), trade.getPrice()});
            this.log.info("\u5f53\u524d\u6a21\u7ec4\u51c0\u6301\u4ed3\uff1a[{}]", (Object)this.ctx.getModuleAccount().getNonclosedNetPosition(unifiedSymbol));
            this.log.info("\u5f53\u524d\u6a21\u7ec4\u72b6\u6001\uff1a{}", (Object)this.ctx.getState());
        }
    }

    @Override
    public void setContext(IModuleContext context) {
        this.ctx = context;
        this.log = this.ctx.getLogger();
        this.initIndicators();
        this.initMultiContractHandler();
    }

    public IModuleContext getContext() {
        return (IModuleContext)this.ctx;
    }

    protected void initIndicators() {
    }

    protected void initMultiContractHandler() {
    }

    @Override
    public void onTick(CoreField.TickField tick) {
        if (!this.canProceed()) {
            return;
        }
        if (this.tickHandlerMap.containsKey(tick.getUnifiedSymbol())) {
            this.tickHandlerMap.get(tick.getUnifiedSymbol()).onTick(tick);
        }
    }

    protected void addTickHandler(String unifiedSymbol, TickHandler handler) {
        this.tickHandlerMap.put(unifiedSymbol, handler);
    }

    @Override
    public void onMergedBar(CoreField.BarField bar) {
        if (!this.canProceed(bar)) {
            return;
        }
        if (this.barHandlerMap.containsKey(bar.getUnifiedSymbol())) {
            this.barHandlerMap.get(bar.getUnifiedSymbol()).onMergedBar(bar);
        }
    }

    protected boolean canProceed() {
        return this.barCache.isEmpty() && this.numOfBarsToPrepare == 0;
    }

    protected boolean canProceed(CoreField.BarField bar) {
        if (this.barCache.size() < this.numOfBarsToPrepare) {
            if (this.barCache.isEmpty() || this.barCache.peek().getUnifiedSymbol().equals(bar.getUnifiedSymbol())) {
                this.barCache.offer(bar);
            }
            return false;
        }
        this.numOfBarsToPrepare = 0;
        this.barCache.clear();
        return true;
    }

    protected void addBarHandler(String unifiedSymbol, BarHandler handler) {
        this.barHandlerMap.put(unifiedSymbol, handler);
    }

    @Override
    @Generated
    public JSONObject getStoreObject() {
        return this.storeObject;
    }

    @Override
    @Generated
    public void setStoreObject(JSONObject storeObject) {
        this.storeObject = storeObject;
    }

    protected static interface TickHandler
    extends TickDataAware {
    }

    protected static interface BarHandler
    extends MergedBarListener {
    }
}

