/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator.momentum;

import java.util.List;
import org.dromara.northstar.indicator.AbstractIndicator;
import org.dromara.northstar.indicator.Indicator;
import org.dromara.northstar.indicator.constant.ValueType;
import org.dromara.northstar.indicator.helper.SimpleValueIndicator;
import org.dromara.northstar.indicator.model.Configuration;
import org.dromara.northstar.indicator.model.Num;
import org.dromara.northstar.indicator.trend.SMAIndicator;

public class RSIIndicator
extends AbstractIndicator
implements Indicator {
    private Indicator close;
    private Indicator numerator;
    private Indicator denominator;

    public RSIIndicator(Configuration cfg, int barCount) {
        super(cfg);
        this.close = new SimpleValueIndicator(cfg.toBuilder().valueType(ValueType.CLOSE).visible(false).build());
        this.numerator = new SMAIndicator(cfg.toBuilder().visible(false).build(), barCount, 1);
        this.denominator = new SMAIndicator(cfg.toBuilder().visible(false).build(), barCount, 1);
    }

    @Override
    public List<Indicator> dependencies() {
        return List.of(this.close);
    }

    @Override
    protected Num evaluate(Num num) {
        if (!this.close.isReady()) {
            return Num.NaN();
        }
        Num numeratorUpdateVal = Num.of(Math.max(this.close.value(0) - this.close.value(-1), 0.0), num.timestamp(), num.unstable());
        Num denominatorUpdateVal = Num.of(Math.abs(this.close.value(0) - this.close.value(-1)), num.timestamp(), num.unstable());
        this.numerator.update(numeratorUpdateVal);
        this.denominator.update(denominatorUpdateVal);
        double val = this.numerator.value(0) / this.denominator.value(0) * 100.0;
        return Num.of(val, num.timestamp(), num.unstable());
    }
}

