/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.constant;

import lombok.Generated;
import org.dromara.northstar.common.constant.SignalOperation;
import org.dromara.northstar.common.exception.TradeException;
import org.dromara.northstar.common.model.Tuple;
import xyz.redtorch.pb.CoreEnum;
import xyz.redtorch.pb.CoreField;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ClosingPolicy {
    FIRST_IN_FIRST_OUT("\u5148\u5f00\u5148\u5e73"){

        @Override
        public Tuple<CoreEnum.OffsetFlagEnum, Integer> resolve(SignalOperation operation, CoreField.PositionField position, int signalVol) {
            if (operation.isOpen()) {
                return Tuple.of(CoreEnum.OffsetFlagEnum.OF_Open, signalVol);
            }
            if (position.getYdPosition() - position.getYdFrozen() > 0) {
                return Tuple.of(CoreEnum.OffsetFlagEnum.OF_CloseYesterday, Math.min(position.getYdPosition() - position.getYdFrozen(), signalVol));
            }
            if (position.getTdPosition() - position.getTdFrozen() > 0) {
                return Tuple.of(CoreEnum.OffsetFlagEnum.OF_CloseToday, Math.min(position.getTdPosition() - position.getTdFrozen(), signalVol));
            }
            throw new TradeException(String.format("%s\u6ca1\u6709\u8db3\u591f\u6301\u4ed3\u53ef\u5e73\u4ed3\uff0c\u5e73\u4ed3\u6570\uff1a%d\u624b\uff0c\u5b9e\u9645\u53ef\u7528\uff1a%d\u624b", position.getContract().getName(), signalVol, position.getPosition() - position.getFrozen()));
        }
    }
    ,
    FIRST_IN_LAST_OUT("\u5e73\u4eca\u4f18\u5148"){

        @Override
        public Tuple<CoreEnum.OffsetFlagEnum, Integer> resolve(SignalOperation operation, CoreField.PositionField position, int signalVol) {
            if (operation.isOpen()) {
                return Tuple.of(CoreEnum.OffsetFlagEnum.OF_Open, signalVol);
            }
            if (position.getTdPosition() - position.getTdFrozen() > 0) {
                return Tuple.of(CoreEnum.OffsetFlagEnum.OF_CloseToday, Math.min(position.getTdPosition() - position.getTdFrozen(), signalVol));
            }
            if (position.getYdPosition() - position.getYdFrozen() > 0) {
                return Tuple.of(CoreEnum.OffsetFlagEnum.OF_CloseYesterday, Math.min(position.getYdPosition() - position.getYdFrozen(), signalVol));
            }
            throw new IllegalStateException(String.format("%s\u6ca1\u6709\u8db3\u591f\u6301\u4ed3\u53ef\u5e73\u4ed3\uff0c\u5e73\u4ed3\u6570\uff1a%d\u624b\uff0c\u5b9e\u9645\u53ef\u7528\uff1a%d\u624b", position.getContract().getName(), signalVol, position.getPosition() - position.getFrozen()));
        }
    }
    ,
    CLOSE_NONTODAY_HEGDE_TODAY("\u5e73\u6628\u9501\u4eca"){

        @Override
        public Tuple<CoreEnum.OffsetFlagEnum, Integer> resolve(SignalOperation operation, CoreField.PositionField position, int signalVol) {
            if (operation.isClose() && position.getYdPosition() - position.getYdFrozen() > 0) {
                return Tuple.of(CoreEnum.OffsetFlagEnum.OF_CloseYesterday, Math.min(position.getYdPosition() - position.getYdFrozen(), signalVol));
            }
            return Tuple.of(CoreEnum.OffsetFlagEnum.OF_Open, signalVol);
        }
    };

    private String name;

    private ClosingPolicy(String name) {
        this.name = name;
    }

    public abstract Tuple<CoreEnum.OffsetFlagEnum, Integer> resolve(SignalOperation var1, CoreField.PositionField var2, int var3);

    @Generated
    public String getName() {
        return this.name;
    }
}

