/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.utils;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dromara.northstar.common.constant.ChannelType;
import xyz.redtorch.pb.CoreEnum;
import xyz.redtorch.pb.CoreField;

public class ContractUtils {
    private ContractUtils() {
    }

    public static List<String> getMonthlyUnifiedSymbolOfIndexContract(String unifiedSymbolOfIndexContract, CoreEnum.ExchangeEnum exchange) {
        ArrayList<String> resultList = new ArrayList<String>();
        LocalDate now = LocalDate.now();
        for (int i = 0; i < 13; ++i) {
            LocalDate date = now.plusMonths(i);
            int year = date.getYear();
            int month = date.getMonthValue();
            String yearStr = exchange == CoreEnum.ExchangeEnum.CZCE ? String.valueOf(year).substring(3) : String.valueOf(year).substring(2);
            String monthStr = String.format("%02d", month);
            String symbol = unifiedSymbolOfIndexContract.replace("0000", yearStr + monthStr);
            resultList.add(symbol);
        }
        return resultList;
    }

    public static boolean isSame(CoreField.ContractField c1, CoreField.ContractField c2) {
        return StringUtils.equals((CharSequence)c1.getContractId(), (CharSequence)c2.getContractId());
    }

    public static ChannelType channelTypeOf(CoreField.ContractField c) {
        return ChannelType.valueOf(c.getChannelType());
    }
}

