/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.utils;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class LocalEnvUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalEnvUtils.class);
    private static Environment env;

    private LocalEnvUtils() {
    }

    public static String getInet4Address() throws SocketException {
        log.info("\u6b63\u5728\u81ea\u52a8\u83b7\u53d6IP");
        Enumeration<NetworkInterface> allNetworkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (allNetworkInterfaces.hasMoreElements()) {
            NetworkInterface netIntf = allNetworkInterfaces.nextElement();
            if (netIntf.isLoopback() || netIntf.isVirtual() || !netIntf.isUp() || netIntf.getDisplayName().contains("VM")) continue;
            Enumeration<InetAddress> inetAddrs = netIntf.getInetAddresses();
            while (inetAddrs.hasMoreElements()) {
                InetAddress inetAddr = inetAddrs.nextElement();
                if (!(inetAddr instanceof Inet4Address)) continue;
                Inet4Address inet4 = (Inet4Address)inetAddr;
                return inet4.getHostAddress();
            }
        }
        throw new SocketException("\u6ca1\u6709\u627e\u5230IPv4\u7684IP\u4fe1\u606f");
    }

    public static String getHostname() {
        String hostname = "Unknown";
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            hostname = localHost.getHostName();
        }
        catch (UnknownHostException e) {
            log.error("\u65e0\u6cd5\u83b7\u53d6\u4e3b\u673a\u540d: " + e.getMessage());
        }
        return hostname;
    }

    public static String getPCName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "unknowHost";
        }
    }

    private static byte[] getMACAddressBytes() throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface ni = networkInterfaces.nextElement();
            byte[] hardwareAddress = ni.getHardwareAddress();
            if (hardwareAddress == null) continue;
            return hardwareAddress;
        }
        throw new IllegalStateException("\u6ca1\u6709\u67e5\u5230MAC\u4fe1\u606f");
    }

    public static String getMACAddress() {
        String macAddr = "";
        try {
            byte[] hardwareAddress = LocalEnvUtils.getMACAddressBytes();
            CharSequence[] hexadecimalFormat = new String[hardwareAddress.length];
            for (int i = 0; i < hardwareAddress.length; ++i) {
                hexadecimalFormat[i] = String.format("%02X", hardwareAddress[i]);
            }
            macAddr = String.join((CharSequence)"-", hexadecimalFormat);
        }
        catch (Exception e) {
            log.warn("", (Throwable)e);
        }
        log.info("\u5f53\u524d\u7cfb\u7edfMAC\u5730\u5740\uff1a{}", (Object)macAddr);
        return macAddr;
    }

    public static void setEnvironment(Environment env) {
        LocalEnvUtils.env = env;
    }

    public static Environment getEnvironment() {
        return env;
    }
}

