/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.model;

import com.alibaba.fastjson2.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.springframework.util.Assert;

public class ResultSet {
    private String[] fields;
    private String[][] items;

    private int fieldIndex(String fieldName) {
        Assert.hasText((String)fieldName, (String)"\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        for (int i = 0; i < this.fields.length; ++i) {
            if (!fieldName.equals(this.fields[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("\u627e\u4e0d\u5230\u5b57\u6bb5\uff1a" + fieldName);
    }

    public String getFieldValue(String fieldName, int row) {
        int idx = this.fieldIndex(fieldName);
        return this.items[row][idx];
    }

    public void setFieldValue(String fieldName, int row, String value) {
        int idx = this.fieldIndex(fieldName);
        this.items[row][idx] = value;
    }

    public void setFieldName(String fromName, String toName) {
        this.fields[this.fieldIndex((String)fromName)] = toName;
    }

    public int size() {
        return this.items.length;
    }

    public List<JSONObject> toJSONList() {
        ArrayList<JSONObject> results = new ArrayList<JSONObject>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            JSONObject json = new JSONObject();
            for (String field : this.getFields()) {
                json.put((Object)field, (Object)this.getFieldValue(field, i));
            }
            results.add(json);
        }
        return results;
    }

    @Generated
    ResultSet(String[] fields, String[][] items) {
        this.fields = fields;
        this.items = items;
    }

    @Generated
    public static ResultSetBuilder builder() {
        return new ResultSetBuilder();
    }

    @Generated
    public String[] getFields() {
        return this.fields;
    }

    @Generated
    public String[][] getItems() {
        return this.items;
    }

    @Generated
    public void setFields(String[] fields) {
        this.fields = fields;
    }

    @Generated
    public void setItems(String[][] items) {
        this.items = items;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultSet)) {
            return false;
        }
        ResultSet other = (ResultSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getFields(), other.getFields())) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.getItems(), (Object[])other.getItems());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResultSet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getFields());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getItems());
        return result;
    }

    @Generated
    public String toString() {
        return "ResultSet(fields=" + Arrays.deepToString(this.getFields()) + ", items=" + Arrays.deepToString((Object[])this.getItems()) + ")";
    }

    @Generated
    public static class ResultSetBuilder {
        @Generated
        private String[] fields;
        @Generated
        private String[][] items;

        @Generated
        ResultSetBuilder() {
        }

        @Generated
        public ResultSetBuilder fields(String[] fields) {
            this.fields = fields;
            return this;
        }

        @Generated
        public ResultSetBuilder items(String[][] items) {
            this.items = items;
            return this;
        }

        @Generated
        public ResultSet build() {
            return new ResultSet(this.fields, this.items);
        }

        @Generated
        public String toString() {
            return "ResultSet.ResultSetBuilder(fields=" + Arrays.deepToString(this.fields) + ", items=" + Arrays.deepToString((Object[])this.items) + ")";
        }
    }
}

