/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.model.core;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Optional;
import lombok.Generated;
import org.dromara.northstar.common.Timed;
import org.dromara.northstar.common.constant.ChannelType;
import org.dromara.northstar.common.constant.DateTimeConstant;
import org.dromara.northstar.common.model.core.Contract;
import org.springframework.util.Assert;
import xyz.redtorch.pb.CoreField;

public record Bar(String gatewayId, Contract contract, LocalDate actionDay, LocalTime actionTime, LocalDate tradingDay, long actionTimestamp, double openPrice, double highPrice, double lowPrice, double closePrice, double openInterest, double openInterestDelta, long volume, long volumeDelta, double turnover, double turnoverDelta, double preOpenInterest, double preClosePrice, double preSettlePrice, ChannelType channelType) implements Timed
{
    public CoreField.BarField toBarField() {
        return CoreField.BarField.newBuilder().setGatewayId(Optional.ofNullable(this.gatewayId).orElse(this.contract.gatewayId())).setUnifiedSymbol(this.contract.unifiedSymbol()).setActionDay(this.actionDay.format(DateTimeConstant.D_FORMAT_INT_FORMATTER)).setActionTime(this.actionTime.format(DateTimeConstant.T_FORMAT_FORMATTER)).setTradingDay(this.tradingDay.format(DateTimeConstant.D_FORMAT_INT_FORMATTER)).setActionTimestamp(this.actionTimestamp).setOpenPrice(this.openPrice).setHighPrice(this.highPrice).setLowPrice(this.lowPrice).setClosePrice(this.closePrice).setOpenInterest(this.openInterest).setOpenInterestDelta(this.openInterestDelta).setVolume(this.volume).setVolumeDelta(this.volumeDelta).setTurnover(this.turnover).setTurnoverDelta(this.turnoverDelta).setPreOpenInterest(this.preOpenInterest).setPreClosePrice(this.preClosePrice).setPreSettlePrice(this.preSettlePrice).setChannelType(this.channelType.toString()).build();
    }

    public static Bar of(CoreField.BarField bar, Contract contract) {
        Assert.isTrue((boolean)contract.unifiedSymbol().equals(bar.getUnifiedSymbol()), () -> String.format("\u5408\u7ea6\u4fe1\u606f\u4e0d\u4e00\u81f4\uff1a\u671f\u671b%s \u5b9e\u9645%s", bar.getUnifiedSymbol(), contract.unifiedSymbol()));
        return Bar.builder().gatewayId(bar.getGatewayId()).contract(contract).actionDay(LocalDate.parse(bar.getActionDay(), DateTimeConstant.D_FORMAT_INT_FORMATTER)).actionTime(LocalTime.parse(bar.getActionTime(), DateTimeConstant.T_FORMAT_FORMATTER)).tradingDay(LocalDate.parse(bar.getTradingDay(), DateTimeConstant.D_FORMAT_INT_FORMATTER)).actionTimestamp(bar.getActionTimestamp()).openPrice(bar.getOpenPrice()).highPrice(bar.getHighPrice()).lowPrice(bar.getLowPrice()).closePrice(bar.getClosePrice()).openInterest(bar.getOpenInterest()).openInterestDelta(bar.getOpenInterestDelta()).volume(bar.getVolume()).volumeDelta(bar.getVolumeDelta()).turnover(bar.getTurnover()).turnoverDelta(bar.getTurnoverDelta()).preOpenInterest(bar.getPreOpenInterest()).preClosePrice(bar.getPreClosePrice()).preSettlePrice(bar.getPreSettlePrice()).channelType(ChannelType.valueOf(bar.getChannelType())).build();
    }

    @Override
    public long getTimestamp() {
        return this.actionTimestamp;
    }

    @Generated
    public static BarBuilder builder() {
        return new BarBuilder();
    }

    @Generated
    public BarBuilder toBuilder() {
        return new BarBuilder().gatewayId(this.gatewayId).contract(this.contract).actionDay(this.actionDay).actionTime(this.actionTime).tradingDay(this.tradingDay).actionTimestamp(this.actionTimestamp).openPrice(this.openPrice).highPrice(this.highPrice).lowPrice(this.lowPrice).closePrice(this.closePrice).openInterest(this.openInterest).openInterestDelta(this.openInterestDelta).volume(this.volume).volumeDelta(this.volumeDelta).turnover(this.turnover).turnoverDelta(this.turnoverDelta).preOpenInterest(this.preOpenInterest).preClosePrice(this.preClosePrice).preSettlePrice(this.preSettlePrice).channelType(this.channelType);
    }

    @Generated
    public static class BarBuilder {
        @Generated
        private String gatewayId;
        @Generated
        private Contract contract;
        @Generated
        private LocalDate actionDay;
        @Generated
        private LocalTime actionTime;
        @Generated
        private LocalDate tradingDay;
        @Generated
        private long actionTimestamp;
        @Generated
        private double openPrice;
        @Generated
        private double highPrice;
        @Generated
        private double lowPrice;
        @Generated
        private double closePrice;
        @Generated
        private double openInterest;
        @Generated
        private double openInterestDelta;
        @Generated
        private long volume;
        @Generated
        private long volumeDelta;
        @Generated
        private double turnover;
        @Generated
        private double turnoverDelta;
        @Generated
        private double preOpenInterest;
        @Generated
        private double preClosePrice;
        @Generated
        private double preSettlePrice;
        @Generated
        private ChannelType channelType;

        @Generated
        BarBuilder() {
        }

        @Generated
        public BarBuilder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        @Generated
        public BarBuilder contract(Contract contract) {
            this.contract = contract;
            return this;
        }

        @Generated
        public BarBuilder actionDay(LocalDate actionDay) {
            this.actionDay = actionDay;
            return this;
        }

        @Generated
        public BarBuilder actionTime(LocalTime actionTime) {
            this.actionTime = actionTime;
            return this;
        }

        @Generated
        public BarBuilder tradingDay(LocalDate tradingDay) {
            this.tradingDay = tradingDay;
            return this;
        }

        @Generated
        public BarBuilder actionTimestamp(long actionTimestamp) {
            this.actionTimestamp = actionTimestamp;
            return this;
        }

        @Generated
        public BarBuilder openPrice(double openPrice) {
            this.openPrice = openPrice;
            return this;
        }

        @Generated
        public BarBuilder highPrice(double highPrice) {
            this.highPrice = highPrice;
            return this;
        }

        @Generated
        public BarBuilder lowPrice(double lowPrice) {
            this.lowPrice = lowPrice;
            return this;
        }

        @Generated
        public BarBuilder closePrice(double closePrice) {
            this.closePrice = closePrice;
            return this;
        }

        @Generated
        public BarBuilder openInterest(double openInterest) {
            this.openInterest = openInterest;
            return this;
        }

        @Generated
        public BarBuilder openInterestDelta(double openInterestDelta) {
            this.openInterestDelta = openInterestDelta;
            return this;
        }

        @Generated
        public BarBuilder volume(long volume) {
            this.volume = volume;
            return this;
        }

        @Generated
        public BarBuilder volumeDelta(long volumeDelta) {
            this.volumeDelta = volumeDelta;
            return this;
        }

        @Generated
        public BarBuilder turnover(double turnover) {
            this.turnover = turnover;
            return this;
        }

        @Generated
        public BarBuilder turnoverDelta(double turnoverDelta) {
            this.turnoverDelta = turnoverDelta;
            return this;
        }

        @Generated
        public BarBuilder preOpenInterest(double preOpenInterest) {
            this.preOpenInterest = preOpenInterest;
            return this;
        }

        @Generated
        public BarBuilder preClosePrice(double preClosePrice) {
            this.preClosePrice = preClosePrice;
            return this;
        }

        @Generated
        public BarBuilder preSettlePrice(double preSettlePrice) {
            this.preSettlePrice = preSettlePrice;
            return this;
        }

        @Generated
        public BarBuilder channelType(ChannelType channelType) {
            this.channelType = channelType;
            return this;
        }

        @Generated
        public Bar build() {
            return new Bar(this.gatewayId, this.contract, this.actionDay, this.actionTime, this.tradingDay, this.actionTimestamp, this.openPrice, this.highPrice, this.lowPrice, this.closePrice, this.openInterest, this.openInterestDelta, this.volume, this.volumeDelta, this.turnover, this.turnoverDelta, this.preOpenInterest, this.preClosePrice, this.preSettlePrice, this.channelType);
        }

        @Generated
        public String toString() {
            return "Bar.BarBuilder(gatewayId=" + this.gatewayId + ", contract=" + String.valueOf(this.contract) + ", actionDay=" + String.valueOf(this.actionDay) + ", actionTime=" + String.valueOf(this.actionTime) + ", tradingDay=" + String.valueOf(this.tradingDay) + ", actionTimestamp=" + this.actionTimestamp + ", openPrice=" + this.openPrice + ", highPrice=" + this.highPrice + ", lowPrice=" + this.lowPrice + ", closePrice=" + this.closePrice + ", openInterest=" + this.openInterest + ", openInterestDelta=" + this.openInterestDelta + ", volume=" + this.volume + ", volumeDelta=" + this.volumeDelta + ", turnover=" + this.turnover + ", turnoverDelta=" + this.turnoverDelta + ", preOpenInterest=" + this.preOpenInterest + ", preClosePrice=" + this.preClosePrice + ", preSettlePrice=" + this.preSettlePrice + ", channelType=" + String.valueOf((Object)this.channelType) + ")";
        }
    }
}

