/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.utils;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import lombok.Generated;
import org.dromara.northstar.common.constant.SignalOperation;
import org.dromara.northstar.common.model.core.Contract;
import org.dromara.northstar.common.model.core.Tick;
import org.dromara.northstar.strategy.IModuleStrategyContext;
import org.dromara.northstar.strategy.constant.PriceType;
import org.dromara.northstar.strategy.model.TradeIntent;
import org.slf4j.Logger;
import org.springframework.util.Assert;
import xyz.redtorch.pb.CoreEnum;

public class TradeHelper {
    private final IModuleStrategyContext context;
    private final Contract tradeContract;
    private final long defaultTimeout;
    private final Logger logger;
    private PriceType priceType = PriceType.OPP_PRICE;

    public TradeHelper(IModuleStrategyContext context, Contract tradeContract) {
        this(context, tradeContract, 5000L);
    }

    public TradeHelper(IModuleStrategyContext context, Contract tradeContract, long defaultTimeout) {
        Assert.notNull((Object)tradeContract, (String)"\u4ea4\u6613\u5408\u7ea6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)context, (String)"\u6a21\u7ec4\u4e0a\u4e0b\u6587\u4e0d\u80fd\u4e3a\u7a7a");
        this.context = context;
        this.tradeContract = tradeContract;
        this.defaultTimeout = defaultTimeout;
        this.logger = context.getLogger(this.getClass());
    }

    public void setPriceType(PriceType type) {
        this.priceType = type;
    }

    public int getCloseVolume(CoreEnum.DirectionEnum holdingDirection) {
        CoreEnum.PositionDirectionEnum posDir = switch (holdingDirection) {
            case CoreEnum.DirectionEnum.D_Buy -> CoreEnum.PositionDirectionEnum.PD_Long;
            case CoreEnum.DirectionEnum.D_Sell -> CoreEnum.PositionDirectionEnum.PD_Short;
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)holdingDirection));
        };
        AtomicInteger actualVol = new AtomicInteger();
        this.context.getAccount(this.tradeContract).getPosition(posDir, this.tradeContract).ifPresent(pos -> actualVol.set(pos.position() - pos.frozen()));
        int logicalVol = this.context.getModuleAccount().getNonclosedPosition(this.tradeContract, holdingDirection);
        return Math.max(Math.min(actualVol.get(), logicalVol), 1);
    }

    public static double spreadRateInPercentage(Tick numerator, Tick denominator, boolean buyNumerator) {
        double numeratorPrice = buyNumerator ? numerator.askPrice().get(0) : numerator.bidPrice().get(0);
        double denominatorPrice = buyNumerator ? denominator.bidPrice().get(0) : denominator.askPrice().get(0);
        return (numeratorPrice / denominatorPrice - 1.0) * 100.0;
    }

    public void doBuyOpen(double price, int vol, long timeout, Predicate<Double> priceDiffConditionToAbort) {
        this.logger.info("\u9650\u4ef7\u4e70\u5f00");
        this.doAction(SignalOperation.BUY_OPEN, price, vol, timeout, priceDiffConditionToAbort);
    }

    public void doBuyOpen(int vol) {
        this.logger.info("\u5bf9\u624b\u4ef7\u4e70\u5f00");
        this.doAction(SignalOperation.BUY_OPEN, vol);
    }

    public void doSellOpen(double price, int vol, long timeout, Predicate<Double> priceDiffConditionToAbort) {
        this.logger.info("\u9650\u4ef7\u5356\u5f00");
        this.doAction(SignalOperation.SELL_OPEN, price, vol, timeout, priceDiffConditionToAbort);
    }

    public void doSellOpen(int vol) {
        this.logger.info("\u5bf9\u624b\u4ef7\u5356\u5f00");
        this.doAction(SignalOperation.SELL_OPEN, vol);
    }

    public void doBuyClose(double price, int vol, long timeout, Predicate<Double> priceDiffConditionToAbort) {
        this.logger.info("\u9650\u4ef7\u4e70\u5e73");
        this.doAction(SignalOperation.BUY_CLOSE, price, vol, timeout, priceDiffConditionToAbort);
    }

    public void doBuyClose(int vol) {
        this.logger.info("\u5bf9\u624b\u4ef7\u4e70\u5e73");
        this.doAction(SignalOperation.BUY_CLOSE, vol);
    }

    public void doSellClose(double price, int vol, long timeout, Predicate<Double> priceDiffConditionToAbort) {
        this.logger.info("\u9650\u4ef7\u5356\u5e73");
        this.doAction(SignalOperation.SELL_CLOSE, price, vol, timeout, priceDiffConditionToAbort);
    }

    public void doSellClose(int vol) {
        this.logger.info("\u5bf9\u624b\u4ef7\u5356\u5e73");
        this.doAction(SignalOperation.SELL_CLOSE, vol);
    }

    private void doAction(SignalOperation operation, double price, int vol, long timeout, Predicate<Double> priceDiffConditionToAbort) {
        this.context.submitOrderReq(TradeIntent.builder().contract(this.tradeContract).operation(operation).price(price).priceType(PriceType.LIMIT_PRICE).timeout(timeout).volume(vol).priceDiffConditionToAbort(priceDiffConditionToAbort).build());
    }

    private void doAction(SignalOperation operation, int vol) {
        this.context.submitOrderReq(TradeIntent.builder().contract(this.tradeContract).operation(operation).priceType(this.priceType).timeout(this.defaultTimeout).volume(vol).build());
    }

    @Generated
    public static TradeHelperBuilder builder() {
        return new TradeHelperBuilder();
    }

    @Generated
    public static class TradeHelperBuilder {
        @Generated
        private IModuleStrategyContext context;
        @Generated
        private Contract tradeContract;
        @Generated
        private long defaultTimeout;

        @Generated
        TradeHelperBuilder() {
        }

        @Generated
        public TradeHelperBuilder context(IModuleStrategyContext context) {
            this.context = context;
            return this;
        }

        @Generated
        public TradeHelperBuilder tradeContract(Contract tradeContract) {
            this.tradeContract = tradeContract;
            return this;
        }

        @Generated
        public TradeHelper build() {
            return new TradeHelper(this.context, this.tradeContract);
        }

        @Generated
        public String toString() {
            return "TradeHelper.TradeHelperBuilder(context=" + String.valueOf(this.context) + ", tradeContract=" + String.valueOf(this.tradeContract) + ")";
        }

        @Generated
        public TradeHelperBuilder defaultTimeout(long defaultTimeout) {
            this.defaultTimeout = defaultTimeout;
            return this;
        }
    }
}

