/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.gateway.mktdata;

import java.time.LocalDate;
import java.util.List;
import java.util.function.Consumer;
import org.dromara.northstar.common.IDataSource;
import org.dromara.northstar.common.model.core.Bar;
import org.dromara.northstar.common.model.core.Contract;
import org.dromara.northstar.gateway.utils.DataLoadUtil;

public class DataSourceDataLoader {
    private IDataSource ds;
    private DataLoadUtil util = new DataLoadUtil();

    public DataSourceDataLoader(IDataSource ds) {
        this.ds = ds;
    }

    public void loadMinutelyData(Contract contract, LocalDate startDate, LocalDate endDate, Consumer<List<Bar>> sectionCallback) {
        this.util.splitByWeek(startDate, endDate, (start, end) -> sectionCallback.accept(this.ds.getMinutelyData(contract, (LocalDate)start, (LocalDate)end)));
    }

    public void loadQuarterlyData(Contract contract, LocalDate startDate, LocalDate endDate, Consumer<List<Bar>> sectionCallback) {
        this.util.splitByMonth(startDate, endDate, (start, end) -> sectionCallback.accept(this.ds.getQuarterlyData(contract, (LocalDate)start, (LocalDate)end)));
    }

    public void loadHourlyData(Contract contract, LocalDate startDate, LocalDate endDate, Consumer<List<Bar>> sectionCallback) {
        this.util.splitByMonth(startDate, endDate, (start, end) -> sectionCallback.accept(this.ds.getHourlyData(contract, (LocalDate)start, (LocalDate)end)));
    }

    public void loadDailyData(Contract contract, LocalDate startDate, LocalDate endDate, Consumer<List<Bar>> sectionCallback) {
        this.util.splitByYear(startDate, endDate, (start, end) -> sectionCallback.accept(this.ds.getDailyData(contract, (LocalDate)start, (LocalDate)end)));
    }
}

