/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.gateway.mktdata;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import lombok.Generated;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.dromara.northstar.common.constant.Constants;
import org.dromara.northstar.common.constant.TickType;
import org.dromara.northstar.common.model.core.Contract;
import org.dromara.northstar.common.model.core.Tick;
import org.dromara.northstar.gateway.contract.IndexContract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexTicker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndexTicker.class);
    private IndexContract idxContract;
    private Consumer<Tick> onTickCallback;
    private final Set<Contract> memberContracts;
    private ConcurrentHashMap<Contract, Tick> tickMap = new ConcurrentHashMap(20);
    private long lastTickTimestamp = -1L;
    private double lastPrice;
    private double highPrice;
    private double lowPrice;
    private double openPrice;
    private long totalVolume;
    private long totalVolumeDelta;
    private double totalOpenInterest;
    private double totalOpenInterestDelta;
    private double totalTurnover;
    private double totalTurnoverDelta;
    private double preClose;
    private double preOpenInterest;
    private double preSettlePrice;
    private double settlePrice;
    private Tick lastIdxTick;

    public IndexTicker(IndexContract idxContract, Consumer<Tick> onTickCallback) {
        this.idxContract = idxContract;
        this.memberContracts = idxContract.memberContracts().stream().map(c -> c.contract()).collect(Collectors.toSet());
        this.onTickCallback = onTickCallback;
    }

    private double activeRate() {
        return (double)this.tickMap.size() / (double)this.memberContracts.size();
    }

    public synchronized void update(Tick tick) {
        if (!this.memberContracts.contains(tick.contract())) {
            log.warn("[{}]\u6307\u6570TICK\u751f\u6210\u5668\uff0c\u65e0\u6cd5\u5904\u7406 [{}] \u7684\u884c\u60c5\u6570\u636e", (Object)this.idxContract.contract().unifiedSymbol(), (Object)tick.contract().unifiedSymbol());
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("{}\u6307\u6570\u5408\u6210\u5668\u6536\u5230TICK: {} {} {} {}", new Object[]{this.idxContract.contract().unifiedSymbol(), tick.contract().symbol(), tick.actionDay(), tick.actionTime(), tick.actionTimestamp()});
        }
        if (0L < this.lastTickTimestamp && this.lastTickTimestamp < tick.actionTimestamp()) {
            boolean isReady;
            boolean bl = isReady = this.activeRate() > 0.7;
            if (isReady) {
                Double zeroD = Constants.ZERO_D;
                Integer zero = Constants.ZERO;
                this.calculate();
                this.lastIdxTick = Tick.builder().gatewayId(tick.gatewayId()).contract(this.idxContract.contract()).actionDay(tick.actionDay()).actionTime(tick.actionTime()).tradingDay(tick.tradingDay()).actionTimestamp(this.lastTickTimestamp).openPrice(this.openPrice).highPrice(this.highPrice).lowPrice(this.lowPrice).lastPrice(this.lastPrice).openInterest(this.totalOpenInterest).openInterestDelta(this.totalOpenInterestDelta).volume(this.totalVolume).volumeDelta(this.totalVolumeDelta).turnover(this.totalTurnover).turnoverDelta(this.totalTurnoverDelta).preClosePrice(this.preClose).preOpenInterest(this.preOpenInterest).preSettlePrice(this.preSettlePrice).settlePrice(this.settlePrice).askPrice(List.of(zeroD, zeroD, zeroD, zeroD, zeroD)).bidPrice(List.of(zeroD, zeroD, zeroD, zeroD, zeroD)).askVolume(List.of(zero, zero, zero, zero, zero)).bidVolume(List.of(zero, zero, zero, zero, zero)).type(tick.type()).channelType(tick.channelType()).build();
                this.onTickCallback.accept(this.lastIdxTick);
            } else {
                log.debug("{}\u56e0\u6708\u4efd\u6570\u636e\u4e0d\u8db3\uff0c\u672a\u8fbe\u5230\u6307\u6570\u5408\u6210\u6761\u4ef6\uff0c\u5ffd\u7565\u6307\u6570TICK\u5408\u6210\u8ba1\u7b97\uff1a\u5f53\u524d\u5408\u7ea6\u6570[{}]\uff0c\u603b\u5408\u7ea6\u6570[{}]\uff0c\u6d3b\u8dc3\u7387[{}]", new Object[]{this.idxContract.contract().unifiedSymbol(), this.tickMap.size(), this.memberContracts.size(), this.activeRate()});
            }
        }
        if (tick.type() == TickType.MARKET_TICK && tick.actionTimestamp() > this.lastTickTimestamp) {
            this.lastTickTimestamp = tick.actionTimestamp();
        }
        this.tickMap.compute(tick.contract(), (k, v) -> tick);
    }

    private void calculate() {
        List<Tick> ticks = this.tickMap.values().stream().toList();
        RealMatrix priceMat = this.matrixOf(ticks);
        RealMatrix oiWeight = this.oiWeighted(priceMat);
        Array2DRowRealMatrix bcResult = new Array2DRowRealMatrix(priceMat.getRowDimension(), priceMat.getColumnDimension());
        for (int i = 0; i < priceMat.getRowDimension(); ++i) {
            double scalar = oiWeight.getEntry(i, 0);
            bcResult.setRow(i, priceMat.getRowMatrix(i).scalarMultiply(scalar).getRow(0));
        }
        this.preOpenInterest = DoubleStream.of(priceMat.getColumn(13)).sum();
        this.totalOpenInterest = DoubleStream.of(priceMat.getColumn(0)).sum();
        this.totalOpenInterestDelta = Objects.nonNull(this.lastIdxTick) ? this.totalOpenInterest - this.lastIdxTick.openInterest() : DoubleStream.of(priceMat.getColumn(12)).sum();
        this.totalVolume = (long)DoubleStream.of(priceMat.getColumn(8)).sum();
        this.totalVolumeDelta = Objects.nonNull(this.lastIdxTick) ? this.totalVolume - this.lastIdxTick.volume() : (long)DoubleStream.of(priceMat.getColumn(9)).sum();
        this.totalTurnover = (long)DoubleStream.of(priceMat.getColumn(10)).sum();
        this.totalTurnoverDelta = Objects.nonNull(this.lastIdxTick) ? this.totalTurnover - this.lastIdxTick.turnover() : (double)((long)DoubleStream.of(priceMat.getColumn(11)).sum());
        this.openPrice = this.roundWithPriceTick(DoubleStream.of(bcResult.getColumn(1)).sum());
        this.highPrice = this.roundWithPriceTick(DoubleStream.of(bcResult.getColumn(2)).sum());
        this.lowPrice = this.roundWithPriceTick(DoubleStream.of(bcResult.getColumn(3)).sum());
        this.lastPrice = this.roundWithPriceTick(DoubleStream.of(bcResult.getColumn(4)).sum());
        this.settlePrice = this.roundWithPriceTick(DoubleStream.of(bcResult.getColumn(5)).sum());
        this.preClose = this.roundWithPriceTick(DoubleStream.of(bcResult.getColumn(6)).sum());
        this.preSettlePrice = this.roundWithPriceTick(DoubleStream.of(bcResult.getColumn(7)).sum());
    }

    private RealMatrix matrixOf(List<Tick> ticks) {
        int numFeatures = 14;
        int numTicks = ticks.size();
        Array2DRowRealMatrix tickMatrix = new Array2DRowRealMatrix(numTicks, numFeatures);
        for (int i = 0; i < numTicks; ++i) {
            tickMatrix.setRow(i, this.vectorize(ticks.get(i)));
        }
        return tickMatrix;
    }

    private double[] vectorize(Tick t) {
        return new double[]{t.openInterest(), t.openPrice(), t.highPrice(), t.lowPrice(), t.lastPrice(), t.settlePrice(), t.preClosePrice(), t.preSettlePrice(), t.volume(), t.volumeDelta(), t.turnover(), t.turnoverDelta(), t.openInterestDelta(), t.preOpenInterest()};
    }

    private RealMatrix oiWeighted(RealMatrix matrix) {
        RealMatrix oi = matrix.getColumnMatrix(0);
        double sumOI = DoubleStream.of(oi.getColumn(0)).sum();
        for (int i = 0; i < oi.getRowDimension(); ++i) {
            oi.setEntry(i, 0, oi.getEntry(i, 0) / sumOI);
        }
        return oi;
    }

    private double roundWithPriceTick(double weightedPrice) {
        int enlargePrice = (int)(weightedPrice * 1000.0);
        int enlargePriceTick = (int)(this.idxContract.contract().priceTick() * 1000.0);
        int numOfTicks = enlargePrice / enlargePriceTick;
        int tickCarry = enlargePrice % enlargePriceTick < enlargePriceTick / 2 ? 0 : 1;
        return this.idxContract.contract().priceTick() * (double)(numOfTicks + tickCarry);
    }
}

