/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator.volume;

import java.util.List;
import org.dromara.northstar.indicator.AbstractIndicator;
import org.dromara.northstar.indicator.Indicator;
import org.dromara.northstar.indicator.constant.ValueType;
import org.dromara.northstar.indicator.helper.SimpleValueIndicator;
import org.dromara.northstar.indicator.model.Configuration;
import org.dromara.northstar.indicator.model.Num;

public class VWAPIndicator
extends AbstractIndicator
implements Indicator {
    private Indicator close;
    private Indicator volume;

    public VWAPIndicator(Configuration cfg, int barCount) {
        super(cfg);
        this.close = new SimpleValueIndicator(cfg.toBuilder().cacheLength(barCount).visible(false).build());
        this.volume = new SimpleValueIndicator(cfg.toBuilder().cacheLength(barCount).valueType(ValueType.VOL_DELTA).visible(false).build());
    }

    @Override
    public List<Indicator> dependencies() {
        return List.of(this.close, this.volume);
    }

    @Override
    protected Num evaluate(Num num) {
        if (!this.volume.isReady()) {
            return Num.NaN();
        }
        double accVol = this.volume.getData().stream().mapToDouble(Num::value).sum();
        List<Num> volumes = this.volume.getData();
        List<Num> closes = this.close.getData();
        double val = 0.0;
        for (int i = 0; i < volumes.size(); ++i) {
            val += closes.get(i).value() * volumes.get(i).value();
        }
        return Num.of(val / accVol, num.timestamp(), num.unstable());
    }
}

