/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.strategy;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import lombok.Generated;
import org.dromara.northstar.common.TickDataAware;
import org.dromara.northstar.common.model.ContractSimpleInfo;
import org.dromara.northstar.common.model.ModuleAccountDescription;
import org.dromara.northstar.common.model.core.Bar;
import org.dromara.northstar.common.model.core.Contract;
import org.dromara.northstar.common.model.core.Order;
import org.dromara.northstar.common.model.core.Tick;
import org.dromara.northstar.common.model.core.Trade;
import org.dromara.northstar.common.utils.FieldUtils;
import org.dromara.northstar.strategy.IModuleContext;
import org.dromara.northstar.strategy.IModuleStrategyContext;
import org.dromara.northstar.strategy.MergedBarListener;
import org.dromara.northstar.strategy.TradeStrategy;
import org.slf4j.Logger;

public abstract class AbstractStrategy
implements TradeStrategy {
    protected JSONObject storeObject;
    protected IModuleStrategyContext ctx;
    protected Map<Contract, TickHandler> tickHandlerMap = new HashMap<Contract, TickHandler>();
    protected Map<Contract, BarHandler> barHandlerMap = new HashMap<Contract, BarHandler>();
    private Logger logger;
    protected int numOfBarsToPrepare;
    private Queue<Bar> barCache = new LinkedList<Bar>();

    @Override
    public void onOrder(Order order) {
    }

    @Override
    public void onTrade(Trade trade) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("\u6a21\u7ec4\u6210\u4ea4 [{} {} {} \u64cd\u4f5c\uff1a{}{} {}\u624b {}]", new Object[]{trade.contract().unifiedSymbol(), trade.tradeDate(), trade.tradeTime(), FieldUtils.chn(trade.direction()), FieldUtils.chn(trade.offsetFlag()), trade.volume(), trade.price()});
            this.logger.info("\u5f53\u524d\u6a21\u7ec4\u51c0\u6301\u4ed3\uff1a[{}]", (Object)this.ctx.getModuleAccount().getNonclosedNetPosition(trade.contract()));
            this.logger.info("\u5f53\u524d\u6a21\u7ec4\u72b6\u6001\uff1a{}", (Object)this.ctx.getState());
        }
    }

    @Override
    public void setContext(IModuleContext context) {
        this.ctx = context;
        this.logger = this.ctx.getLogger(this.getClass());
        this.initIndicators();
        this.initMultiContractHandler();
    }

    public IModuleContext getContext() {
        return (IModuleContext)this.ctx;
    }

    public boolean isEnabled() {
        return this.getContext().isEnabled();
    }

    protected List<ContractSimpleInfo> bindedContracts() {
        return this.getContext().getModule().getModuleDescription().getModuleAccountSettingsDescription().stream().map(ModuleAccountDescription::getBindedContracts).flatMap(Collection::stream).toList();
    }

    protected void initIndicators() {
    }

    protected void initMultiContractHandler() {
    }

    @Override
    public void onTick(Tick tick) {
        if (!this.canProceed()) {
            return;
        }
        if (this.tickHandlerMap.containsKey(tick.contract())) {
            this.tickHandlerMap.get(tick.contract()).onTick(tick);
        }
    }

    protected void addTickHandler(Contract contract, TickHandler handler) {
        this.tickHandlerMap.put(contract, handler);
    }

    @Override
    public void onMergedBar(Bar bar) {
        if (!this.canProceed(bar)) {
            return;
        }
        if (this.barHandlerMap.containsKey(bar.contract())) {
            this.barHandlerMap.get(bar.contract()).onMergedBar(bar);
        }
    }

    protected boolean canProceed() {
        return this.barCache.isEmpty() && this.numOfBarsToPrepare == 0;
    }

    protected boolean canProceed(Bar bar) {
        if (this.barCache.size() < this.numOfBarsToPrepare) {
            if (this.barCache.isEmpty() || this.barCache.peek().contract().equals(bar.contract())) {
                this.barCache.offer(bar);
            }
            return false;
        }
        this.numOfBarsToPrepare = 0;
        this.barCache.clear();
        return true;
    }

    protected void addBarHandler(Contract contract, BarHandler handler) {
        this.barHandlerMap.put(contract, handler);
    }

    @Override
    @Generated
    public JSONObject getStoreObject() {
        return this.storeObject;
    }

    @Override
    @Generated
    public void setStoreObject(JSONObject storeObject) {
        this.storeObject = storeObject;
    }

    protected static interface TickHandler
    extends TickDataAware {
    }

    protected static interface BarHandler
    extends MergedBarListener {
    }
}

