/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.constant;

import java.util.HashMap;
import java.util.Map;

public enum SignalOperation {
    BUY_OPEN("\u591a\u5f00"),
    SELL_OPEN("\u7a7a\u5f00"),
    BUY_CLOSE("\u591a\u5e73"),
    SELL_CLOSE("\u7a7a\u5e73");

    private String text;
    private static final Map<String, SignalOperation> enumMap;

    private SignalOperation(String text) {
        this.text = text;
    }

    public String text() {
        return this.text;
    }

    public boolean isOpen() {
        return this == BUY_OPEN || this == SELL_OPEN;
    }

    public boolean isSell() {
        return this == SELL_OPEN || this == SELL_CLOSE;
    }

    public boolean isBuy() {
        return this == BUY_OPEN || this == BUY_CLOSE;
    }

    public boolean isClose() {
        return this == BUY_CLOSE || this == SELL_CLOSE;
    }

    public static SignalOperation parse(String val) {
        if (enumMap.containsKey(val)) {
            return enumMap.get(val);
        }
        throw new IllegalArgumentException("\u672a\u77e5\u4fe1\u53f7\uff1a" + val);
    }

    static {
        enumMap = new HashMap<String, SignalOperation>();
        enumMap.put("\u591a\u5f00", BUY_OPEN);
        enumMap.put("\u7a7a\u5f00", SELL_OPEN);
        enumMap.put("\u591a\u5e73", BUY_CLOSE);
        enumMap.put("\u7a7a\u5e73", SELL_CLOSE);
    }
}

