/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.model.core;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.dromara.northstar.common.Timed;
import org.dromara.northstar.common.constant.ChannelType;
import org.dromara.northstar.common.constant.DateTimeConstant;
import org.dromara.northstar.common.constant.TickType;
import org.dromara.northstar.common.model.core.Contract;
import xyz.redtorch.pb.CoreField;

public record Tick(String gatewayId, Contract contract, LocalDate actionDay, LocalTime actionTime, LocalDate tradingDay, long actionTimestamp, double lastPrice, double avgPrice, double iopv, long volumeDelta, long volume, double turnover, double turnoverDelta, double openInterest, double openInterestDelta, double settlePrice, double preOpenInterest, double preClosePrice, double preSettlePrice, double openPrice, double highPrice, double lowPrice, double upperLimit, double lowerLimit, List<Double> bidPrice, List<Double> askPrice, List<Integer> bidVolume, List<Integer> askVolume, TickType type, JSONObject otherInfo, ChannelType channelType) implements Timed
{
    public CoreField.TickField toTickField() {
        return CoreField.TickField.newBuilder().setGatewayId(Optional.ofNullable(this.gatewayId).orElse(this.contract.gatewayId())).setUnifiedSymbol(this.contract.unifiedSymbol()).setActionDay(this.actionDay.format(DateTimeConstant.D_FORMAT_INT_FORMATTER)).setActionTime(this.actionTime.format(DateTimeConstant.T_FORMAT_WITH_MS_INT_FORMATTER)).setTradingDay(this.tradingDay.format(DateTimeConstant.D_FORMAT_INT_FORMATTER)).setActionTimestamp(this.actionTimestamp).setLastPrice(this.lastPrice).setAvgPrice(this.avgPrice).setIopv(this.iopv).setVolumeDelta(this.volumeDelta).setVolume(this.volume).setTurnover(this.turnover).setTurnoverDelta(this.turnoverDelta).setOpenInterest(this.openInterest).setOpenInterestDelta(this.openInterestDelta).setSettlePrice(this.settlePrice).setPreOpenInterest(this.preOpenInterest).setPreClosePrice(this.preClosePrice).setPreSettlePrice(this.preSettlePrice).setOpenPrice(this.openPrice).setHighPrice(this.highPrice).setLowPrice(this.lowPrice).setUpperLimit(this.upperLimit).setLowerLimit(this.lowerLimit).addAllBidPrice(this.bidPrice).addAllAskPrice(this.askPrice).addAllBidVolume(this.bidVolume).addAllAskVolume(this.askVolume).setChannelType(this.channelType.toString()).build();
    }

    @Override
    public long getTimestamp() {
        return this.actionTimestamp;
    }

    @Generated
    public static TickBuilder builder() {
        return new TickBuilder();
    }

    @Generated
    public static class TickBuilder {
        @Generated
        private String gatewayId;
        @Generated
        private Contract contract;
        @Generated
        private LocalDate actionDay;
        @Generated
        private LocalTime actionTime;
        @Generated
        private LocalDate tradingDay;
        @Generated
        private long actionTimestamp;
        @Generated
        private double lastPrice;
        @Generated
        private double avgPrice;
        @Generated
        private double iopv;
        @Generated
        private long volumeDelta;
        @Generated
        private long volume;
        @Generated
        private double turnover;
        @Generated
        private double turnoverDelta;
        @Generated
        private double openInterest;
        @Generated
        private double openInterestDelta;
        @Generated
        private double settlePrice;
        @Generated
        private double preOpenInterest;
        @Generated
        private double preClosePrice;
        @Generated
        private double preSettlePrice;
        @Generated
        private double openPrice;
        @Generated
        private double highPrice;
        @Generated
        private double lowPrice;
        @Generated
        private double upperLimit;
        @Generated
        private double lowerLimit;
        @Generated
        private List<Double> bidPrice;
        @Generated
        private List<Double> askPrice;
        @Generated
        private List<Integer> bidVolume;
        @Generated
        private List<Integer> askVolume;
        @Generated
        private TickType type;
        @Generated
        private JSONObject otherInfo;
        @Generated
        private ChannelType channelType;

        @Generated
        TickBuilder() {
        }

        @Generated
        public TickBuilder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        @Generated
        public TickBuilder contract(Contract contract) {
            this.contract = contract;
            return this;
        }

        @Generated
        public TickBuilder actionDay(LocalDate actionDay) {
            this.actionDay = actionDay;
            return this;
        }

        @Generated
        public TickBuilder actionTime(LocalTime actionTime) {
            this.actionTime = actionTime;
            return this;
        }

        @Generated
        public TickBuilder tradingDay(LocalDate tradingDay) {
            this.tradingDay = tradingDay;
            return this;
        }

        @Generated
        public TickBuilder actionTimestamp(long actionTimestamp) {
            this.actionTimestamp = actionTimestamp;
            return this;
        }

        @Generated
        public TickBuilder lastPrice(double lastPrice) {
            this.lastPrice = lastPrice;
            return this;
        }

        @Generated
        public TickBuilder avgPrice(double avgPrice) {
            this.avgPrice = avgPrice;
            return this;
        }

        @Generated
        public TickBuilder iopv(double iopv) {
            this.iopv = iopv;
            return this;
        }

        @Generated
        public TickBuilder volumeDelta(long volumeDelta) {
            this.volumeDelta = volumeDelta;
            return this;
        }

        @Generated
        public TickBuilder volume(long volume) {
            this.volume = volume;
            return this;
        }

        @Generated
        public TickBuilder turnover(double turnover) {
            this.turnover = turnover;
            return this;
        }

        @Generated
        public TickBuilder turnoverDelta(double turnoverDelta) {
            this.turnoverDelta = turnoverDelta;
            return this;
        }

        @Generated
        public TickBuilder openInterest(double openInterest) {
            this.openInterest = openInterest;
            return this;
        }

        @Generated
        public TickBuilder openInterestDelta(double openInterestDelta) {
            this.openInterestDelta = openInterestDelta;
            return this;
        }

        @Generated
        public TickBuilder settlePrice(double settlePrice) {
            this.settlePrice = settlePrice;
            return this;
        }

        @Generated
        public TickBuilder preOpenInterest(double preOpenInterest) {
            this.preOpenInterest = preOpenInterest;
            return this;
        }

        @Generated
        public TickBuilder preClosePrice(double preClosePrice) {
            this.preClosePrice = preClosePrice;
            return this;
        }

        @Generated
        public TickBuilder preSettlePrice(double preSettlePrice) {
            this.preSettlePrice = preSettlePrice;
            return this;
        }

        @Generated
        public TickBuilder openPrice(double openPrice) {
            this.openPrice = openPrice;
            return this;
        }

        @Generated
        public TickBuilder highPrice(double highPrice) {
            this.highPrice = highPrice;
            return this;
        }

        @Generated
        public TickBuilder lowPrice(double lowPrice) {
            this.lowPrice = lowPrice;
            return this;
        }

        @Generated
        public TickBuilder upperLimit(double upperLimit) {
            this.upperLimit = upperLimit;
            return this;
        }

        @Generated
        public TickBuilder lowerLimit(double lowerLimit) {
            this.lowerLimit = lowerLimit;
            return this;
        }

        @Generated
        public TickBuilder bidPrice(List<Double> bidPrice) {
            this.bidPrice = bidPrice;
            return this;
        }

        @Generated
        public TickBuilder askPrice(List<Double> askPrice) {
            this.askPrice = askPrice;
            return this;
        }

        @Generated
        public TickBuilder bidVolume(List<Integer> bidVolume) {
            this.bidVolume = bidVolume;
            return this;
        }

        @Generated
        public TickBuilder askVolume(List<Integer> askVolume) {
            this.askVolume = askVolume;
            return this;
        }

        @Generated
        public TickBuilder type(TickType type) {
            this.type = type;
            return this;
        }

        @Generated
        public TickBuilder otherInfo(JSONObject otherInfo) {
            this.otherInfo = otherInfo;
            return this;
        }

        @Generated
        public TickBuilder channelType(ChannelType channelType) {
            this.channelType = channelType;
            return this;
        }

        @Generated
        public Tick build() {
            return new Tick(this.gatewayId, this.contract, this.actionDay, this.actionTime, this.tradingDay, this.actionTimestamp, this.lastPrice, this.avgPrice, this.iopv, this.volumeDelta, this.volume, this.turnover, this.turnoverDelta, this.openInterest, this.openInterestDelta, this.settlePrice, this.preOpenInterest, this.preClosePrice, this.preSettlePrice, this.openPrice, this.highPrice, this.lowPrice, this.upperLimit, this.lowerLimit, this.bidPrice, this.askPrice, this.bidVolume, this.askVolume, this.type, this.otherInfo, this.channelType);
        }

        @Generated
        public String toString() {
            return "Tick.TickBuilder(gatewayId=" + this.gatewayId + ", contract=" + String.valueOf(this.contract) + ", actionDay=" + String.valueOf(this.actionDay) + ", actionTime=" + String.valueOf(this.actionTime) + ", tradingDay=" + String.valueOf(this.tradingDay) + ", actionTimestamp=" + this.actionTimestamp + ", lastPrice=" + this.lastPrice + ", avgPrice=" + this.avgPrice + ", iopv=" + this.iopv + ", volumeDelta=" + this.volumeDelta + ", volume=" + this.volume + ", turnover=" + this.turnover + ", turnoverDelta=" + this.turnoverDelta + ", openInterest=" + this.openInterest + ", openInterestDelta=" + this.openInterestDelta + ", settlePrice=" + this.settlePrice + ", preOpenInterest=" + this.preOpenInterest + ", preClosePrice=" + this.preClosePrice + ", preSettlePrice=" + this.preSettlePrice + ", openPrice=" + this.openPrice + ", highPrice=" + this.highPrice + ", lowPrice=" + this.lowPrice + ", upperLimit=" + this.upperLimit + ", lowerLimit=" + this.lowerLimit + ", bidPrice=" + String.valueOf(this.bidPrice) + ", askPrice=" + String.valueOf(this.askPrice) + ", bidVolume=" + String.valueOf(this.bidVolume) + ", askVolume=" + String.valueOf(this.askVolume) + ", type=" + String.valueOf((Object)this.type) + ", otherInfo=" + String.valueOf(this.otherInfo) + ", channelType=" + String.valueOf((Object)this.channelType) + ")";
        }
    }
}

