/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.dromara.northstar.common.model.core.Bar;
import org.dromara.northstar.common.model.core.Tick;
import org.dromara.northstar.common.model.core.TimeSlot;
import org.dromara.northstar.common.model.core.TradeTimeDefinition;
import org.dromara.northstar.common.utils.CommonUtils;

public class MarketDataUtils {
    MarketDataUtils() {
    }

    public static boolean isOpenningBar(Bar bar) {
        TradeTimeDefinition ttd = bar.contract().contractDefinition().tradeTimeDef();
        return ttd.timeSlots().get(0).start().equals(bar.actionTime());
    }

    public static boolean isEndingBar(Bar bar) {
        TradeTimeDefinition ttd = bar.contract().contractDefinition().tradeTimeDef();
        for (TimeSlot ts : ttd.timeSlots()) {
            if (!ts.end().equals(bar.actionTime())) continue;
            return true;
        }
        return false;
    }

    public static boolean isOpenningTick(Tick tick, int seconds) {
        TradeTimeDefinition ttd = tick.contract().contractDefinition().tradeTimeDef();
        LocalTime openTime = ttd.timeSlots().get(0).start();
        LocalTime cutoffTime = openTime.plusSeconds(seconds);
        return tick.actionTime().isBefore(cutoffTime);
    }

    public static int secondsToWholeMin(Tick tick) {
        long t = tick.actionTimestamp();
        return (int)(60L - t % 60000L / 1000L);
    }

    public static int minutesToDayEnd(Bar bar) {
        TradeTimeDefinition ttd = bar.contract().contractDefinition().tradeTimeDef();
        LocalDate tradingDay = bar.tradingDay();
        LocalTime endTime = ttd.timeSlots().get(ttd.timeSlots().size() - 1).end();
        LocalDateTime endDateTime = LocalDateTime.of(tradingDay, endTime);
        return (int)(CommonUtils.localDateTimeToMills(endDateTime) - bar.actionTimestamp()) / 60000;
    }
}

