/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.gateway.contract;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.dromara.northstar.common.constant.ChannelType;
import org.dromara.northstar.common.model.Identifier;
import org.dromara.northstar.common.model.core.Contract;
import org.dromara.northstar.gateway.IContract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import xyz.redtorch.pb.CoreEnum;

public class OptionChainContract
implements IContract {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OptionChainContract.class);
    private final String name;
    private final List<IContract> memberContracts;
    private final Identifier identifier;

    public OptionChainContract(IContract underlyingContract, List<IContract> memberContracts) {
        Assert.notEmpty(memberContracts, (String)"\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        this.memberContracts = memberContracts;
        this.identifier = Identifier.of("OCC#" + underlyingContract.identifier().value());
        this.name = underlyingContract.name() + "\u671f\u6743\u94fe";
    }

    @Override
    public boolean subscribe() {
        for (IContract c : this.memberContracts) {
            if (c.subscribe()) continue;
            log.warn("[{}] \u5408\u7ea6\u8ba2\u9605\u5931\u8d25", (Object)c.contract().unifiedSymbol());
        }
        return true;
    }

    @Override
    public boolean unsubscribe() {
        for (IContract c : this.memberContracts) {
            if (c.unsubscribe()) continue;
            log.warn("[{}] \u5408\u7ea6\u53d6\u6d88\u8ba2\u9605\u5931\u8d25", (Object)c.contract().unifiedSymbol());
        }
        return true;
    }

    @Override
    public List<IContract> memberContracts() {
        return this.memberContracts;
    }

    @Override
    public Contract contract() {
        Contract seed = this.memberContracts.get(0).contract();
        String unifiedSymbol = String.format("%s@%s@%s", new Object[]{this.name, seed.exchange(), seed.productClass()});
        return seed.toBuilder().name(this.name).fullName(this.name).unifiedSymbol(unifiedSymbol).symbol(this.name).contractId(this.identifier.value()).build();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Identifier identifier() {
        return this.identifier;
    }

    @Override
    public CoreEnum.ProductClassEnum productClass() {
        return this.memberContracts.get(0).productClass();
    }

    @Override
    public CoreEnum.ExchangeEnum exchange() {
        return this.memberContracts.get(0).exchange();
    }

    @Override
    public String gatewayId() {
        return this.memberContracts.get(0).gatewayId();
    }

    @Override
    public ChannelType channelType() {
        return this.memberContracts.get(0).channelType();
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OptionChainContract other = (OptionChainContract)obj;
        return Objects.equals(this.name, other.name);
    }
}

