/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator.model;

import lombok.Generated;
import org.dromara.northstar.common.model.core.Contract;
import org.dromara.northstar.indicator.constant.PeriodUnit;
import org.dromara.northstar.indicator.constant.ValueType;

public record Configuration(String indicatorName, Contract contract, Integer numOfUnits, PeriodUnit period, ValueType valueType, Integer cacheLength, Boolean ifPlotPerBar, Boolean visible) {
    public Configuration {
        if (numOfUnits == null) {
            numOfUnits = 1;
        }
        if (period == null) {
            period = PeriodUnit.MINUTE;
        }
        if (valueType == null) {
            valueType = ValueType.CLOSE;
        }
        if (cacheLength == null) {
            cacheLength = 16;
        }
        if (ifPlotPerBar == null) {
            ifPlotPerBar = false;
        }
        if (visible == null) {
            visible = true;
        }
        if (indicatorName == null) {
            indicatorName = "";
        }
        if (contract == null) {
            throw new IllegalArgumentException(indicatorName + "\u672a\u7ed1\u5b9a\u8ba1\u7b97\u5408\u7ea6");
        }
    }

    public String indicatorID() {
        return String.format("%s_%d%s", this.indicatorName(), this.numOfUnits(), this.period().symbol());
    }

    @Generated
    public static ConfigurationBuilder builder() {
        return new ConfigurationBuilder();
    }

    @Generated
    public ConfigurationBuilder toBuilder() {
        return new ConfigurationBuilder().indicatorName(this.indicatorName).contract(this.contract).numOfUnits(this.numOfUnits).period(this.period).valueType(this.valueType).cacheLength(this.cacheLength).ifPlotPerBar(this.ifPlotPerBar).visible(this.visible);
    }

    @Generated
    public static class ConfigurationBuilder {
        @Generated
        private String indicatorName;
        @Generated
        private Contract contract;
        @Generated
        private Integer numOfUnits;
        @Generated
        private PeriodUnit period;
        @Generated
        private ValueType valueType;
        @Generated
        private Integer cacheLength;
        @Generated
        private Boolean ifPlotPerBar;
        @Generated
        private Boolean visible;

        @Generated
        ConfigurationBuilder() {
        }

        @Generated
        public ConfigurationBuilder indicatorName(String indicatorName) {
            this.indicatorName = indicatorName;
            return this;
        }

        @Generated
        public ConfigurationBuilder contract(Contract contract) {
            this.contract = contract;
            return this;
        }

        @Generated
        public ConfigurationBuilder numOfUnits(Integer numOfUnits) {
            this.numOfUnits = numOfUnits;
            return this;
        }

        @Generated
        public ConfigurationBuilder period(PeriodUnit period) {
            this.period = period;
            return this;
        }

        @Generated
        public ConfigurationBuilder valueType(ValueType valueType) {
            this.valueType = valueType;
            return this;
        }

        @Generated
        public ConfigurationBuilder cacheLength(Integer cacheLength) {
            this.cacheLength = cacheLength;
            return this;
        }

        @Generated
        public ConfigurationBuilder ifPlotPerBar(Boolean ifPlotPerBar) {
            this.ifPlotPerBar = ifPlotPerBar;
            return this;
        }

        @Generated
        public ConfigurationBuilder visible(Boolean visible) {
            this.visible = visible;
            return this;
        }

        @Generated
        public Configuration build() {
            return new Configuration(this.indicatorName, this.contract, this.numOfUnits, this.period, this.valueType, this.cacheLength, this.ifPlotPerBar, this.visible);
        }

        @Generated
        public String toString() {
            return "Configuration.ConfigurationBuilder(indicatorName=" + this.indicatorName + ", contract=" + String.valueOf(this.contract) + ", numOfUnits=" + this.numOfUnits + ", period=" + String.valueOf((Object)this.period) + ", valueType=" + String.valueOf((Object)this.valueType) + ", cacheLength=" + this.cacheLength + ", ifPlotPerBar=" + this.ifPlotPerBar + ", visible=" + this.visible + ")";
        }
    }
}

