/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator.trend;

import java.util.List;
import org.dromara.northstar.indicator.AbstractIndicator;
import org.dromara.northstar.indicator.Indicator;
import org.dromara.northstar.indicator.model.Configuration;
import org.dromara.northstar.indicator.model.Num;
import org.dromara.northstar.indicator.trend.EMAIndicator;
import org.dromara.northstar.indicator.trend.MAIndicator;

public class PuBuIndicator
extends AbstractIndicator
implements Indicator {
    private Indicator ema;
    private Indicator ma1;
    private Indicator ma2;

    public PuBuIndicator(Configuration cfg, int barCount) {
        super(cfg);
        this.ema = new EMAIndicator(cfg.toBuilder().indicatorName(cfg.indicatorName() + "_ema").visible(false).build(), barCount);
        this.ma1 = new MAIndicator(cfg.toBuilder().indicatorName(cfg.indicatorName() + "_ma1").visible(false).build(), barCount * 2);
        this.ma2 = new MAIndicator(cfg.toBuilder().indicatorName(cfg.indicatorName() + "_ma2").visible(false).build(), barCount * 4);
    }

    @Override
    public List<Indicator> dependencies() {
        return List.of(this.ema, this.ma1, this.ma2);
    }

    @Override
    protected Num evaluate(Num num) {
        if (!(this.ema.isReady() && this.ma1.isReady() && this.ma2.isReady())) {
            return Num.NaN();
        }
        return Num.of((this.ema.value(0) + this.ma1.value(0) + this.ma2.value(0)) / 3.0, num.timestamp(), num.unstable());
    }
}

