/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator.volume;

import java.util.ArrayList;
import java.util.List;
import org.dromara.northstar.indicator.AbstractIndicator;
import org.dromara.northstar.indicator.Indicator;
import org.dromara.northstar.indicator.constant.PeriodUnit;
import org.dromara.northstar.indicator.constant.ValueType;
import org.dromara.northstar.indicator.helper.SimpleValueIndicator;
import org.dromara.northstar.indicator.model.Configuration;
import org.dromara.northstar.indicator.model.Num;

public class IntraDaySettlePriceIndicator
extends AbstractIndicator
implements Indicator {
    private Indicator close;
    private Indicator volume;
    private List<Num> vols = new ArrayList<Num>();
    private long tradingDayIntFormat;

    public IntraDaySettlePriceIndicator(Configuration cfg) {
        super(cfg.toBuilder().numOfUnits(1).period(PeriodUnit.MINUTE).valueType(ValueType.TRADE_DATE).build());
        this.close = new SimpleValueIndicator(Configuration.builder().contract(cfg.contract()).valueType(ValueType.CLOSE).visible(false).build());
        this.volume = new SimpleValueIndicator(Configuration.builder().contract(cfg.contract()).valueType(ValueType.VOL_DELTA).visible(false).build());
    }

    @Override
    public List<Indicator> dependencies() {
        return List.of(this.close, this.volume);
    }

    @Override
    protected Num evaluate(Num num) {
        long curTradeDate = Math.round(num.value());
        if (this.tradingDayIntFormat != curTradeDate) {
            this.tradingDayIntFormat = curTradeDate;
            this.vols.clear();
        }
        if (this.vols.isEmpty() || !this.get(0).unstable()) {
            this.vols.add(this.volume.get(0));
        } else {
            this.vols.set(this.vols.size() - 1, this.volume.get(0));
        }
        double accVol = this.vols.stream().mapToDouble(Num::value).sum();
        double preVal = this.vols.size() == 1 ? 0.0 : this.get(-1).value();
        double factor = this.volume.value(0) / accVol;
        double val = factor * this.close.value(0) + (1.0 - factor) * preVal;
        return Num.of(val, num.timestamp(), num.unstable());
    }
}

