/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.strategy.model;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.dromara.northstar.common.TickDataAware;
import org.dromara.northstar.common.TransactionAware;
import org.dromara.northstar.common.constant.SignalOperation;
import org.dromara.northstar.common.model.core.Contract;
import org.dromara.northstar.common.model.core.Order;
import org.dromara.northstar.common.model.core.Tick;
import org.dromara.northstar.common.model.core.Trade;
import org.dromara.northstar.common.utils.OrderUtils;
import org.dromara.northstar.strategy.IModuleContext;
import org.dromara.northstar.strategy.constant.PriceType;
import org.slf4j.Logger;
import org.springframework.util.Assert;

public class TradeIntent
implements TransactionAware,
TickDataAware {
    private IModuleContext context;
    private final Contract contract;
    private final SignalOperation operation;
    private final PriceType priceType;
    private final double price;
    private final int volume;
    private final long timeout;
    private final Predicate<Double> priceDiffConditionToAbort;
    private Double initialPrice;
    private Logger logger;
    private Set<Trade> trades = new HashSet<Trade>();
    private Optional<String> orderIdRef = Optional.empty();
    private int accVol;
    private boolean terminated;
    private long lastCancelReqTime;

    public TradeIntent(Contract contract, SignalOperation operation, PriceType priceType, double price, int volume, long timeout, Predicate<Double> priceDiffConditionToAbort) {
        Assert.noNullElements(List.of(contract, operation, priceType), (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((volume > 0 ? 1 : 0) != 0, (String)"\u624b\u6570\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
        Assert.isTrue((timeout > 0L ? 1 : 0) != 0, (String)"\u8ba2\u5355\u7b49\u5f85\u65f6\u957f\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
        this.contract = contract;
        this.operation = operation;
        this.priceType = priceType;
        this.price = price;
        this.volume = volume;
        this.timeout = timeout;
        this.priceDiffConditionToAbort = priceDiffConditionToAbort;
    }

    @Override
    public synchronized void onTick(Tick tick) {
        if (!this.contract.equals(tick.contract())) {
            return;
        }
        if (Objects.isNull(this.initialPrice)) {
            this.initialPrice = this.price == 0.0 ? tick.lastPrice() : this.price;
            this.logger.debug("\u4ea4\u6613\u610f\u56fe\u521d\u59cb\u4ef7\u4f4d\uff1a{}", (Object)this.initialPrice);
        }
        if (Objects.nonNull(this.priceDiffConditionToAbort)) {
            double priceDiff = Math.abs(tick.lastPrice() - this.initialPrice);
            this.terminated = this.priceDiffConditionToAbort.test(priceDiff);
            if (this.terminated) {
                this.logger.info("{} {} \u4ef7\u5dee\u8fc7\u5927\u4e2d\u6b62\u4ea4\u6613\u610f\u56fe\uff0c\u5f53\u524d\u4ef7\u5dee\u4e3a{}", new Object[]{tick.actionDay(), tick.actionTime(), priceDiff});
                this.orderIdRef.ifPresent(this.context::cancelOrder);
            }
        }
        if (this.hasTerminated()) {
            this.logger.debug("\u4ea4\u6613\u610f\u56fe\u5df2\u7ec8\u6b62");
            return;
        }
        if (this.orderIdRef.isEmpty() && !this.context.getState().isOrdering()) {
            this.logger.debug("\u4ea4\u6613\u610f\u56fe\u81ea\u52a8\u53d1\u5355");
            this.orderIdRef = this.context.submitOrderReq(this.contract, this.operation, this.priceType, this.restVol(), this.price);
        } else if (this.orderIdRef.isPresent() && this.context.isOrderWaitTimeout(this.orderIdRef.get(), this.timeout) && tick.actionTimestamp() - this.lastCancelReqTime > 3000L) {
            this.logger.debug("\u4ea4\u6613\u610f\u56fe\u81ea\u52a8\u64a4\u5355");
            this.context.cancelOrder(this.orderIdRef.get());
            this.lastCancelReqTime = tick.actionTimestamp();
            if (!this.context.isEnabled()) {
                this.terminated = true;
            }
        }
    }

    private int restVol() {
        return this.volume - this.accVol;
    }

    @Override
    public synchronized void onOrder(Order order) {
        this.orderIdRef.filter(id -> StringUtils.equals((CharSequence)id, (CharSequence)order.originOrderId())).ifPresent(id -> {
            if (OrderUtils.isDoneOrder(order)) {
                CompletableFuture.runAsync(() -> {
                    this.orderIdRef = Optional.empty();
                }, CompletableFuture.delayedExecutor(3L, TimeUnit.SECONDS));
            }
        });
    }

    @Override
    public synchronized void onTrade(Trade trade) {
        this.orderIdRef.filter(id -> StringUtils.equals((CharSequence)id, (CharSequence)trade.originOrderId())).ifPresent(id -> {
            this.accVol += trade.volume();
            this.trades.add(trade);
            if (this.hasTerminated()) {
                double avgDealPrice = this.trades.stream().mapToDouble(tr -> tr.price() * (double)tr.volume()).sum() / (double)this.volume;
                this.logger.info("\u521d\u59cb\u4e0b\u5355\u4ef7\u4e3a\uff1a{}\uff0c\u6700\u7ec8\u6210\u4ea4\u5747\u4ef7\uff1a{}\uff0c\u4ea4\u6613\u6ed1\u70b9\u4e3a\uff1a[{}]\u4e2a\u4ef7\u4f4d", new Object[]{this.initialPrice, avgDealPrice, Math.round(Math.abs(avgDealPrice - this.initialPrice) / this.contract.priceTick())});
            }
        });
    }

    public synchronized boolean hasTerminated() {
        return this.terminated || this.accVol >= this.volume;
    }

    public void setContext(IModuleContext ctx) {
        this.context = ctx;
        this.logger = ctx.getLogger(this.getClass());
    }

    public String toString() {
        return String.format("TradeIntent [contract=%s, operation=%s, priceType=%s, price=%s, volume=%s, timeout=%s]", new Object[]{this.contract.contractId(), this.operation, this.priceType, this.price, this.volume, this.timeout});
    }

    @Generated
    public static TradeIntentBuilder builder() {
        return new TradeIntentBuilder();
    }

    @Generated
    public Contract getContract() {
        return this.contract;
    }

    @Generated
    public SignalOperation getOperation() {
        return this.operation;
    }

    @Generated
    public PriceType getPriceType() {
        return this.priceType;
    }

    @Generated
    public double getPrice() {
        return this.price;
    }

    @Generated
    public int getVolume() {
        return this.volume;
    }

    @Generated
    public static class TradeIntentBuilder {
        @Generated
        private Contract contract;
        @Generated
        private SignalOperation operation;
        @Generated
        private PriceType priceType;
        @Generated
        private double price;
        @Generated
        private int volume;
        @Generated
        private long timeout;
        @Generated
        private Predicate<Double> priceDiffConditionToAbort;

        @Generated
        TradeIntentBuilder() {
        }

        @Generated
        public TradeIntentBuilder contract(Contract contract) {
            this.contract = contract;
            return this;
        }

        @Generated
        public TradeIntentBuilder operation(SignalOperation operation) {
            this.operation = operation;
            return this;
        }

        @Generated
        public TradeIntentBuilder priceType(PriceType priceType) {
            this.priceType = priceType;
            return this;
        }

        @Generated
        public TradeIntentBuilder price(double price) {
            this.price = price;
            return this;
        }

        @Generated
        public TradeIntentBuilder volume(int volume) {
            this.volume = volume;
            return this;
        }

        @Generated
        public TradeIntentBuilder timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public TradeIntentBuilder priceDiffConditionToAbort(Predicate<Double> priceDiffConditionToAbort) {
            this.priceDiffConditionToAbort = priceDiffConditionToAbort;
            return this;
        }

        @Generated
        public TradeIntent build() {
            return new TradeIntent(this.contract, this.operation, this.priceType, this.price, this.volume, this.timeout, this.priceDiffConditionToAbort);
        }

        @Generated
        public String toString() {
            return "TradeIntent.TradeIntentBuilder(contract=" + String.valueOf(this.contract) + ", operation=" + String.valueOf((Object)this.operation) + ", priceType=" + String.valueOf((Object)this.priceType) + ", price=" + this.price + ", volume=" + this.volume + ", timeout=" + this.timeout + ", priceDiffConditionToAbort=" + String.valueOf(this.priceDiffConditionToAbort) + ")";
        }
    }
}

