/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.io.FileUtils;
import org.springframework.util.Assert;

public class CommonUtils {
    private CommonUtils() {
    }

    public static LocalDateTime millsToLocalDateTime(long millis) {
        Instant instant = Instant.ofEpochMilli(millis);
        return instant.atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static long localDateTimeToMills(LocalDateTime ldt) {
        return ldt.toInstant(OffsetDateTime.now().getOffset()).toEpochMilli();
    }

    public static boolean isEquals(double d1, double d2) {
        double eps = 1.0E-6;
        return Math.abs(d1 - d2) < eps;
    }

    public static void copyURLToFileForTmp(String targetDir, URL sourceURL) throws IOException {
        File orginFile = new File(sourceURL.getFile());
        File targetFile = new File(targetDir + File.separator + orginFile.getName());
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        Files.deleteIfExists(targetFile.toPath());
        FileUtils.copyURLToFile((URL)sourceURL, (File)targetFile);
        targetFile.deleteOnExit();
    }

    public static int precisionOf(double priceTick) {
        Assert.isTrue((priceTick > 0.0 ? 1 : 0) != 0, (String)"\u6700\u5c0f\u53d8\u52a8\u4ef7\u4f4d\u5e94\u8be5\u4e3a\u6b63\u6570");
        for (int i = 0; i < 10; ++i) {
            if (!(priceTick * Math.pow(10.0, i) >= 1.0)) continue;
            return i;
        }
        throw new IllegalArgumentException("\u4ef7\u683c\u7cbe\u5ea6\u6700\u591a\u4e3a\u5c0f\u6570\u70b9\u540e\u4e5d\u4f4d");
    }

    public static ThreadFactory virtualThreadFactory(Class<?> clz) {
        Object className = clz.getSimpleName();
        if (((String)className).length() > 10) {
            className = ((String)className).substring(0, 10);
        }
        className = (String)className + "-virtual";
        return Thread.ofVirtual().name((String)className).factory();
    }

    public static ExecutorService newThreadPerTaskExecutor(Class<?> clz) {
        return Executors.newThreadPerTaskExecutor(CommonUtils.virtualThreadFactory(clz));
    }
}

