/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.utils;

import xyz.redtorch.pb.CoreEnum;
import xyz.redtorch.pb.CoreField;

public class FieldUtils {
    private FieldUtils() {
    }

    public static String chn(CoreEnum.DirectionEnum dir) {
        switch (dir) {
            case D_Buy: {
                return "\u591a";
            }
            case D_Sell: {
                return "\u7a7a";
            }
        }
        return "\u672a\u77e5";
    }

    public static String chn(CoreEnum.OffsetFlagEnum offset) {
        switch (offset) {
            case OF_Open: {
                return "\u5f00";
            }
            case OF_Unknown: {
                return "\u672a\u77e5";
            }
            case OF_Close: {
                return "\u5e73";
            }
            case OF_CloseToday: {
                return "\u5e73\u4eca";
            }
            case OF_CloseYesterday: {
                return "\u5e73\u6628";
            }
        }
        return "\u5f3a\u5e73";
    }

    public static String chn(CoreEnum.OrderStatusEnum status) {
        switch (status) {
            case OS_AllTraded: {
                return "\u5168\u6210";
            }
            case OS_Canceled: {
                return "\u5df2\u64a4\u5355";
            }
            case OS_Rejected: {
                return "\u5df2\u62d2\u7edd";
            }
            case OS_Touched: 
            case OS_NoTradeQueueing: {
                return "\u5df2\u6302\u5355";
            }
            case OS_NoTradeNotQueueing: {
                return "\u672a\u6392\u961f";
            }
            case OS_PartTradedNotQueueing: {
                return "\u90e8\u5206\u672a\u6392\u961f";
            }
            case OS_PartTradedQueueing: {
                return "\u90e8\u5206\u6210\u4ea4";
            }
        }
        return "\u672a\u77e5";
    }

    public static boolean isLong(CoreEnum.PositionDirectionEnum position) {
        return position == CoreEnum.PositionDirectionEnum.PD_Long;
    }

    public static boolean isShort(CoreEnum.PositionDirectionEnum position) {
        return position == CoreEnum.PositionDirectionEnum.PD_Short;
    }

    public static boolean isBuy(CoreEnum.DirectionEnum dir) {
        return dir == CoreEnum.DirectionEnum.D_Buy;
    }

    public static boolean isSell(CoreEnum.DirectionEnum dir) {
        return dir == CoreEnum.DirectionEnum.D_Sell;
    }

    public static int directionFactor(CoreEnum.DirectionEnum dir) {
        return switch (dir) {
            case CoreEnum.DirectionEnum.D_Buy -> 1;
            case CoreEnum.DirectionEnum.D_Sell -> -1;
            default -> 0;
        };
    }

    public static double marginRatio(CoreField.ContractField contract, CoreEnum.DirectionEnum dir) {
        return switch (dir) {
            case CoreEnum.DirectionEnum.D_Buy -> contract.getLongMarginRatio();
            case CoreEnum.DirectionEnum.D_Sell -> contract.getShortMarginRatio();
            default -> 0.0;
        };
    }

    public static boolean isOpposite(CoreEnum.DirectionEnum dir1, CoreEnum.DirectionEnum dir2) {
        return dir1 != dir2 && dir1 != CoreEnum.DirectionEnum.D_Unknown && dir2 != CoreEnum.DirectionEnum.D_Unknown;
    }

    public static CoreEnum.DirectionEnum getOpposite(CoreEnum.DirectionEnum dir) {
        return switch (dir) {
            case CoreEnum.DirectionEnum.D_Buy -> CoreEnum.DirectionEnum.D_Sell;
            case CoreEnum.DirectionEnum.D_Sell -> CoreEnum.DirectionEnum.D_Buy;
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)dir));
        };
    }

    public static boolean isOpen(CoreEnum.OffsetFlagEnum offsetFlag) {
        return offsetFlag == CoreEnum.OffsetFlagEnum.OF_Open;
    }

    public static boolean isClose(CoreEnum.OffsetFlagEnum offsetFlag) {
        return offsetFlag != CoreEnum.OffsetFlagEnum.OF_Unknown && offsetFlag != CoreEnum.OffsetFlagEnum.OF_Open;
    }
}

