/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.utils;

import org.dromara.northstar.common.constant.SignalOperation;
import org.dromara.northstar.common.model.OrderRequest;
import org.dromara.northstar.common.model.core.Order;
import xyz.redtorch.pb.CoreEnum;

public class OrderUtils {
    private OrderUtils() {
    }

    public static CoreEnum.DirectionEnum resolveDirection(OrderRequest.TradeOperation opr) {
        return opr.toString().charAt(0) == 'B' ? CoreEnum.DirectionEnum.D_Buy : CoreEnum.DirectionEnum.D_Sell;
    }

    public static CoreEnum.DirectionEnum resolveDirection(SignalOperation opr) {
        return switch (opr) {
            case SignalOperation.BUY_CLOSE, SignalOperation.BUY_OPEN -> CoreEnum.DirectionEnum.D_Buy;
            case SignalOperation.SELL_CLOSE, SignalOperation.SELL_OPEN -> CoreEnum.DirectionEnum.D_Sell;
            default -> CoreEnum.DirectionEnum.D_Unknown;
        };
    }

    public static boolean isOpenningOrder(OrderRequest.TradeOperation opr) {
        return opr.toString().charAt(1) == 'K';
    }

    public static boolean isClosingOrder(OrderRequest.TradeOperation opr) {
        return opr.toString().charAt(1) == 'P';
    }

    public static CoreEnum.PositionDirectionEnum getClosingDirection(CoreEnum.DirectionEnum dir) {
        if (dir == CoreEnum.DirectionEnum.D_Buy) {
            return CoreEnum.PositionDirectionEnum.PD_Short;
        }
        if (dir == CoreEnum.DirectionEnum.D_Sell) {
            return CoreEnum.PositionDirectionEnum.PD_Long;
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u786e\u5b9a[" + String.valueOf((Object)dir) + "]\u7684\u5bf9\u5e94\u6301\u4ed3\u65b9\u5411");
    }

    public static boolean isValidOrder(Order order) {
        return order.orderStatus() != CoreEnum.OrderStatusEnum.OS_Rejected && order.orderStatus() != CoreEnum.OrderStatusEnum.OS_Canceled;
    }

    public static boolean isDoneOrder(Order order) {
        return order.orderStatus() == CoreEnum.OrderStatusEnum.OS_Canceled || order.orderStatus() == CoreEnum.OrderStatusEnum.OS_AllTraded;
    }
}

