/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.common.utils;

import java.time.LocalTime;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import org.dromara.northstar.common.model.core.TradeTimeDefinition;

public class TradeTimeUtil {
    private static final int SEC_PER_MIN = 60;
    private static final int MINS_OF_DAY = 1440;
    private BitSet tradeTimeBitmap = new BitSet(1440);
    private Set<LocalTime> endsOfSection = new HashSet<LocalTime>();

    public TradeTimeUtil(TradeTimeDefinition ttd) {
        ttd.timeSlots().forEach(ts -> {
            LocalTime start = ts.start();
            LocalTime end = ts.end();
            if (end.isBefore(start)) {
                this.tradeTimeBitmap.set(start.plusMinutes(1L).toSecondOfDay() / 60, 1440);
                this.tradeTimeBitmap.set(0, end.toSecondOfDay() / 60);
            } else {
                this.tradeTimeBitmap.set(start.plusMinutes(1L).toSecondOfDay() / 60, end.toSecondOfDay() / 60);
            }
            this.endsOfSection.add(end);
        });
    }

    public boolean withinTradeTime(LocalTime t) {
        LocalTime checkTime = t.withSecond(0).withNano(0).plusMinutes(1L);
        return this.endsOfSection.contains(t) || this.tradeTimeBitmap.get(checkTime.toSecondOfDay() / 60);
    }
}

