/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.gateway.mktdata;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import org.dromara.northstar.common.constant.TickType;
import org.dromara.northstar.common.model.core.Bar;
import org.dromara.northstar.common.model.core.Contract;
import org.dromara.northstar.common.model.core.Tick;
import org.dromara.northstar.common.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinuteBarGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MinuteBarGenerator.class);
    private Long cutoffTime;
    private LocalDateTime cutoffDT;
    private Contract contract;
    private Tick curTick;
    private Consumer<Bar> onBarCallback;
    private double high;
    private double low;
    private double close;
    private double open;
    private long volumeDelta;
    private double openInterestDelta;
    private double turnoverDelta;
    private CompletableFuture<Void> asyncCheck;
    private Runnable forceCloseBar = () -> {
        MinuteBarGenerator minuteBarGenerator = this;
        synchronized (minuteBarGenerator) {
            if (this.curTick != null && System.currentTimeMillis() - this.curTick.actionTimestamp() > TimeUnit.MINUTES.toMillis(2L)) {
                log.debug("\u5f3a\u5236K\u7ebf\u6536\u76d8\uff1a{}", (Object)this.contract.name());
                this.finishOfBar();
            }
        }
    };

    public MinuteBarGenerator(Contract contract, Consumer<Bar> onBarCallback) {
        this.contract = contract;
        this.onBarCallback = onBarCallback;
    }

    public synchronized void update(Tick tick) {
        boolean sameChannel;
        if (tick == null) {
            log.trace("TICK\u6570\u636e\u4e3a\u7a7a\uff0c\u5c06\u88ab\u5ffd\u7565");
            return;
        }
        boolean sameSymbol = this.contract.equals(tick.contract());
        boolean bl = sameChannel = this.contract.channelType() == tick.channelType();
        if (!sameSymbol || !sameChannel) {
            if (!sameSymbol) {
                log.warn("\u5408\u7ea6\u4e0d\u5339\u914d\uff0c\u671f\u671b [{}]\uff0c\u5b9e\u9645 [{}]", (Object)this.contract.contractId(), (Object)tick.contract().contractId());
            }
            if (!sameChannel) {
                log.warn("[{}] \u5408\u7ea6\u6e20\u9053\u4e0d\u5339\u914d\uff0c\u671f\u671b [{}]\uff0c\u5b9e\u9645 [{}]", new Object[]{this.contract.unifiedSymbol(), this.contract.channelType(), tick.channelType()});
            }
            return;
        }
        if (tick.type() != TickType.MARKET_TICK) {
            log.trace("\u5ffd\u7565\u975e\u884c\u60c5\u6570\u636e\uff1a{}", (Object)tick);
            return;
        }
        this.curTick = tick;
        if (Objects.nonNull(this.cutoffTime) && this.cutoffTime < tick.actionTimestamp()) {
            this.finishOfBar();
        }
        if (Objects.isNull(this.cutoffTime)) {
            this.cutoffDT = LocalDateTime.of(tick.actionDay(), tick.actionTime().withSecond(0).withNano(0)).plusMinutes(1L);
            this.cutoffTime = CommonUtils.localDateTimeToMills(this.cutoffDT);
            this.open = tick.lastPrice();
            this.high = tick.lastPrice();
            this.low = tick.lastPrice();
            this.close = tick.lastPrice();
            this.openInterestDelta = 0.0;
            this.volumeDelta = 0L;
            this.turnoverDelta = 0.0;
        }
        this.high = Math.max(tick.lastPrice(), this.high);
        this.low = Math.min(tick.lastPrice(), this.low);
        this.close = tick.lastPrice();
        this.openInterestDelta += tick.openInterestDelta();
        this.volumeDelta += tick.volumeDelta();
        this.turnoverDelta += tick.turnoverDelta();
        if (this.asyncCheck != null) {
            this.asyncCheck.cancel(false);
        }
        this.asyncCheck = CompletableFuture.runAsync(this.forceCloseBar, CompletableFuture.delayedExecutor(2L, TimeUnit.MINUTES));
    }

    public synchronized void finishOfBar() {
        if (Objects.isNull(this.cutoffTime)) {
            return;
        }
        this.onBarCallback.accept(Bar.builder().gatewayId(this.curTick.gatewayId()).channelType(this.curTick.channelType()).contract(this.curTick.contract()).actionDay(this.cutoffDT.toLocalDate()).actionTime(this.cutoffDT.toLocalTime()).actionTimestamp(CommonUtils.localDateTimeToMills(this.cutoffDT)).tradingDay(this.curTick.tradingDay()).openPrice(this.open).highPrice(this.high).lowPrice(this.low).closePrice(this.close).preClosePrice(this.curTick.preClosePrice()).preOpenInterest(this.curTick.preOpenInterest()).preSettlePrice(this.curTick.preSettlePrice()).volume(this.curTick.volume()).volumeDelta(Math.max(0L, this.volumeDelta)).openInterest(this.curTick.openInterest()).openInterestDelta(this.openInterestDelta).turnover(this.curTick.turnover()).turnoverDelta(this.turnoverDelta).build());
        this.cutoffTime = null;
    }
}

