/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.northstar.indicator.constant;

import org.dromara.northstar.common.constant.DateTimeConstant;
import org.dromara.northstar.common.model.core.Bar;

public enum ValueType {
    HIGH{

        @Override
        public double resolve(Bar bar) {
            return bar.highPrice();
        }
    }
    ,
    LOW{

        @Override
        public double resolve(Bar bar) {
            return bar.lowPrice();
        }
    }
    ,
    OPEN{

        @Override
        public double resolve(Bar bar) {
            return bar.openPrice();
        }
    }
    ,
    CLOSE{

        @Override
        public double resolve(Bar bar) {
            return bar.closePrice();
        }
    }
    ,
    BARYCENTER{

        @Override
        public double resolve(Bar bar) {
            return (bar.highPrice() + bar.closePrice() + bar.closePrice() * 2.0) / 4.0;
        }
    }
    ,
    VOL{

        @Override
        public double resolve(Bar bar) {
            return bar.volume();
        }
    }
    ,
    VOL_DELTA{

        @Override
        public double resolve(Bar bar) {
            return bar.volumeDelta();
        }
    }
    ,
    OI{

        @Override
        public double resolve(Bar bar) {
            return bar.openInterest();
        }
    }
    ,
    OI_DELTA{

        @Override
        public double resolve(Bar bar) {
            return bar.openInterestDelta();
        }
    }
    ,
    TRADE_DATE{

        @Override
        public double resolve(Bar bar) {
            return Double.parseDouble(bar.tradingDay().format(DateTimeConstant.D_FORMAT_INT_FORMATTER));
        }
    };


    public abstract double resolve(Bar var1);
}

