package org.dromara.northstar.strategy;

import java.util.List;

import org.dromara.northstar.common.constant.ModuleState;
import org.dromara.northstar.common.model.core.Contract;
import org.dromara.northstar.indicator.Indicator;
import org.dromara.northstar.indicator.constant.PeriodUnit;
import org.dromara.northstar.strategy.model.TradeIntent;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public interface IModuleStrategyContext {
	/**
	 * 为条件添加日志解释
	 * @param expression		判断条件
	 * @param infoMessage		条件成立时的日志输出
	 * @param args				条件成立时的日志参数
	 * @return					条件真假
	 */
	boolean explain(boolean expression, String infoMessage, Object... args);
	/**
	 * 获取合约
	 * @param unifiedSymbol		合约编码
	 * @return					返回合约信息
	 */
	Contract getContract(String unifiedSymbol);
	/**
	 * 获取模组绑定的全部合约
	 * @return
	 */
	List<Contract> bindedContracts();
	/**
	 * 委托下单（根据配置自动处理撤单追单）
	 * @param tradeIntent		交易意图
	 */
	void submitOrderReq(TradeIntent tradeIntent);
	/**
	 * 获取模组周期设置
	 * @return
	 */
	int numOfMinPerMergedBar();
	/**
	 * 获取合约绑定的物理账户对象
	 * @param contract
	 * @return
	 */
	IAccount getAccount(Contract contract);
	/**
	 * 获取模组账户
	 * @param contract
	 * @return
	 */
	IModuleAccount getModuleAccount();
	/**
	 * 获取模组状态
	 * @return
	 */
	ModuleState getState();
	/**
	 * 停用模组策略
	 * @param enabled
	 */
	void disabledModule();
	/**
	 * 获取日志对象
	 * @return
	 */
	Logger getLogger(Class<?> clz);
	/**
	 * 获取日志工厂
	 * @return
	 */
	ILoggerFactory getLoggerFactory();
	/**
	 * 注册指标
	 * @param indicator
	 */
	void registerIndicator(Indicator indicator);
	/**
	 * 设置自定义的风控策略
	 * @param filter
	 */
	void setOrderRequestFilter(OrderRequestFilter filter);
	/**
	 * 获取默认交易手数
	 * @return
	 */
	int getDefaultVolume();
	/**
	 * 注册周期监听器
	 * @param listener
	 */
	void addMergedBarListener(Contract contract, int numOfUnit, PeriodUnit unit, MergedBarListener listener);
}
